package com.samsthenerd.monthofswords.items;

import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class BoneSwordItem extends SwordtemberItem{
    public static final Tier BONE_MATERIAL = new ClassyToolMaterial(180, 4f, 1.5f,
        BlockTags.INCORRECT_FOR_STONE_TOOL, 16, () -> Ingredient.of(Items.BONE));

    public BoneSwordItem(Item.Properties itemSettings) {
        super(BONE_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(BONE_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0xe8e5d2);
    }
}
