/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class BFSHelper {
    public static Map<BlockPos, Integer> runBFS(Level world, BlockPos startingPos, BFSPredicate predicate, int depth, boolean checkDiagonals) {
        BFSNeighbors<BlockPos> straightNeighbors = (fromPos, dist) -> {
            ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(6);
            for (Direction dir : Direction.values()) {
                BlockPos newPos = fromPos.relative(dir);
                if (!predicate.test(world, (BlockPos)fromPos, dist + 1)) continue;
                neighbors.add(newPos);
            }
            return neighbors;
        };
        BFSNeighbors<BlockPos> gayNeighbors = (fromPos, dist) -> {
            ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        BlockPos newPos = fromPos.offset(x, y, z);
                        if (!predicate.test(world, (BlockPos)fromPos, dist + 1)) continue;
                        neighbors.add(newPos);
                    }
                }
            }
            return neighbors;
        };
        return BFSHelper.runBFS(startingPos, checkDiagonals ? gayNeighbors : straightNeighbors, depth);
    }

    public static <T> Map<T, Integer> runBFS(T initial, BFSNeighbors<T> cityPlanner, int depth) {
        HashMap<T, Integer> visited = new HashMap<T, Integer>();
        LinkedList<T> queue = new LinkedList<T>();
        visited.put(initial, 0);
        queue.add(initial);
        while (!queue.isEmpty()) {
            Object procPoint = queue.poll();
            int dist = (Integer)visited.get(procPoint);
            if (dist + 1 > depth) continue;
            for (T nbr : cityPlanner.getNeighbors(procPoint, dist)) {
                if (visited.containsKey(nbr)) continue;
                visited.put(nbr, dist + 1);
                queue.add(nbr);
            }
        }
        return visited;
    }

    @FunctionalInterface
    public static interface BFSPredicate {
        public boolean test(Level var1, BlockPos var2, int var3);
    }

    public static interface BFSNeighbors<T> {
        public Collection<T> getNeighbors(T var1, int var2);
    }
}

