package com.samsthenerd.monthofswords.items;

import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;

public class DivineSwordItem extends SwordtemberItem implements SwordActionHaverServer{
    public DivineSwordItem(Item.Properties itemSettings){
        super(Tiers.NETHERITE, itemSettings.attributes(SwordItem.createAttributes(Tiers.NETHERITE, 3, -2.4f)));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        boolean ready = !user.getCooldowns().isOnCooldown(this);
        ItemStack handStack = user.getItemInHand(hand);
        if(world instanceof ServerLevel sWorld && ready){
            // TODO: make this apply to players around them too maybe?
            user.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 120));
            user.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 120));
            user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 120));
            user.getCooldowns().addCooldown(this, 20 * 60 * 2); // 2 minute cooldown?
            return InteractionResultHolder.success(handStack);
        }
        return ready ? InteractionResultHolder.success(handStack) : InteractionResultHolder.pass(handStack);
    }

    @Override
    public boolean doSwordAction(Player user, ItemStack swordStack) {
        boolean ready = !user.getCooldowns().isOnCooldown(this);
        if(ready){
            // TODO: make this apply to players around them too maybe?
            user.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20 * 15, 2));
            user.addEffect(new MobEffectInstance(MobEffects.ABSORPTION,   20 * 15, 5));
            user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST,     20 * 15, 3));
            user.getCooldowns().addCooldown(this, 20 * 60 * 1); // 1 minute cooldown?
        }
        return ready;
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(ChatFormatting.YELLOW);
    }
}
