/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.lucky;

import com.mojang.serialization.Codec;
import java.util.function.BiFunction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;

public interface LuckyFunction {
    public int getWeight(double var1);

    public int attack(LivingEntity var1, LivingEntity var2);

    public boolean fromDataDriven();

    public record CodeLuckyFunction(BiFunction<LivingEntity, LivingEntity, Integer> attackFunc, int rarityWeight, LuckyModifier modifier) implements LuckyFunction
    {
        @Override
        public int getWeight(double luck) {
            return this.modifier().modify(this.rarityWeight(), luck);
        }

        @Override
        public int attack(LivingEntity target, LivingEntity attacker) {
            return this.attackFunc.apply(target, attacker);
        }

        @Override
        public boolean fromDataDriven() {
            return false;
        }
    }

    public static enum LuckyModifier implements StringRepresentable
    {
        VERYGOOD("verygood", (luck, baseWeight) -> (int)(0.4 * luck * (double)baseWeight.intValue()) + baseWeight),
        GOOD("good", (luck, baseWeight) -> (int)(0.15 * luck * (double)baseWeight.intValue()) + baseWeight),
        NEUTRAL("neutral", (luck, baseWeight) -> baseWeight),
        BAD("bad", (luck, baseWeight) -> (int)(-0.15 * luck * (double)baseWeight.intValue()) + baseWeight),
        VERYBAD("verybad", (luck, baseWeight) -> (int)(-0.4 * luck * (double)baseWeight.intValue()) + baseWeight);

        public final String name;
        private final BiFunction<Double, Integer, Integer> luckModFunc;
        public static final Codec<LuckyModifier> CODEC;

        private LuckyModifier(String name, BiFunction<Double, Integer, Integer> luckModFunc) {
            this.name = name;
            this.luckModFunc = luckModFunc;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int modify(int baseWeight, double luck) {
            return this.luckModFunc.apply(luck, baseWeight);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LuckyModifier::values);
        }
    }

    public static enum Rarity implements StringRepresentable
    {
        COMMON("common", 100),
        UNCOMMON("uncommon", 50),
        RARE("rare", 15),
        EPIC("epic", 5),
        WOWZERS("wowzers", 1);

        public final String name;
        public final int baseWeight;
        public static final Codec<Rarity> CODEC;

        private Rarity(String name, int baseWeight) {
            this.baseWeight = baseWeight;
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Rarity::values);
        }
    }
}

