/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.lucky;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.lucky.DataLuckyFunction;
import com.samsthenerd.monthofswords.lucky.LuckyFunction;
import com.samsthenerd.monthofswords.lucky.LuckyHandler;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class LuckyDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public LuckyDataLoader() {
        super(GSON, "luckyswordfunctions");
    }

    private void loadDataFunction(ResourceLocation id, JsonObject funcObj) {
        SwordsMod.LOGGER.info("loading data function [" + String.valueOf(id) + "]: " + String.valueOf(funcObj));
        int rarityWeight = Optional.ofNullable(funcObj.getAsJsonPrimitive("rarity")).map(r -> r.isString() ? LuckyFunction.Rarity.valueOf((String)r.getAsString().toUpperCase()).baseWeight : r.getAsInt()).orElseThrow(() -> new RuntimeException("No rarity give in lucky function " + String.valueOf(id)));
        LuckyFunction.LuckyModifier luckyMod = Optional.ofNullable(funcObj.get("luckymodifier")).map(JsonElement::getAsString).map(String::toUpperCase).map(LuckyFunction.LuckyModifier::valueOf).orElse(LuckyFunction.LuckyModifier.NEUTRAL);
        int itemDamage = Optional.ofNullable(funcObj.get("itemDamage")).map(JsonElement::getAsInt).orElse(1);
        Optional<LuckyFunction> maybeIdLF = Optional.ofNullable(funcObj.get("function")).map(JsonElement::getAsString).map(ResourceLocation::parse).map(funcId -> new DataLuckyFunction.DataIdLuckyFunction((ResourceLocation)funcId, rarityWeight, luckyMod, itemDamage));
        Optional<LuckyFunction> maybeCommandLF = Optional.ofNullable(funcObj.get("command")).map(JsonElement::getAsString).map(cmd -> new DataLuckyFunction.DataCommandLuckyFunction((String)cmd, id, rarityWeight, luckyMod, itemDamage));
        if (maybeIdLF.isEmpty() && maybeCommandLF.isEmpty()) {
            throw new RuntimeException("No function or command field for lucky function");
        }
        LuckyFunction luckyFunc = maybeIdLF.orElseGet(maybeCommandLF::get);
        LuckyHandler.addLuckyFunction(luckyFunc);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            JsonElement contents = entry.getValue();
            if (contents.isJsonArray()) {
                JsonArray fArrays = contents.getAsJsonArray();
                for (int i = 0; i < fArrays.size(); ++i) {
                    String iStr = Integer.toString(i);
                    JsonObject funcObj = fArrays.get(i).getAsJsonObject();
                    this.loadDataFunction(entry.getKey().withPath(p -> p + iStr), funcObj);
                }
                continue;
            }
            if (!contents.isJsonObject()) continue;
            this.loadDataFunction(entry.getKey(), contents.getAsJsonObject());
        }
    }
}

