/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import java.util.function.UnaryOperator;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class WovenSwordItem
extends SwordtemberItem {
    public static final Vector3f TRANS_BLUE_COLOR = new Vector3f(0.3125f, 0.7421875f, 0.94140625f);
    public static final Vector3f TRANS_PINK_COLOR = new Vector3f(0.984375f, 0.79296875f, 0.8984375f);

    public WovenSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.DIAMOND, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)5, (float)-2.4f)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(16567270);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        attacker.level().playSound(null, attacker.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 100.0f, attacker.getRandom().nextFloat() * 0.4f + 0.8f);
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (user.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)user;
            world.playSound(null, sPlayer.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 100.0f, user.getRandom().nextFloat() * 0.4f + 0.8f);
            Vec3 vel = user.getLookAngle();
            user.push(vel);
            user.hurtMarked = true;
            user.getCooldowns().addCooldown((Item)this, 1000);
            user.makeDashTransgenderly();
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)true);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntDuck) {
            LivingEntDuck attacker = (LivingEntDuck)entity;
            return attacker.isDashingTransgenderly() ? 4.0f : 0.0f;
        }
        return 0.0f;
    }

    public static void makeTransParticles(ServerPlayer player) {
        for (int i = 0; i < 10; ++i) {
            player.serverLevel().sendParticles((ParticleOptions)new DustParticleOptions(player.getRandom().nextBoolean() ? TRANS_BLUE_COLOR : TRANS_PINK_COLOR, 1.0f), player.getX() + player.getRandom().nextDouble(), player.getY() + player.getRandom().nextDouble(), player.getZ() + player.getRandom().nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

