/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GlowSwordItem
extends SwordtemberItem
implements SwordActionHaverServer {
    public GlowSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.DIAMOND, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)2, (float)-2.0f)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(11533026);
    }

    @Override
    public boolean doSwordAction(Player player, ItemStack stack) {
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            List nearEnts = player.level().getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)32.0, (double)32.0, (double)16.0));
            for (Entity ent : nearEnts) {
                if (!(ent instanceof LivingEntity)) continue;
                LivingEntity livEnt = (LivingEntity)ent;
                livEnt.addEffect(new MobEffectInstance(MobEffects.GLOWING, 1200));
                ent.hurt(player.damageSources().magic(), 5.0f);
            }
            player.getCooldowns().addCooldown((Item)this, 900);
            stack.hurtAndBreak(5, (LivingEntity)player, player.getMainHandItem() == stack ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        return true;
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        return target.isCurrentlyGlowing() ? 2.0f : 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 900));
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.getCooldowns().isOnCooldown((Item)this) && !world.isClientSide()) {
            List nearEnts = world.getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)8.0, (double)8.0, (double)8.0));
            for (Entity ent : nearEnts) {
                if (!(ent instanceof LivingEntity)) continue;
                LivingEntity livEnt = (LivingEntity)ent;
                livEnt.addEffect(new MobEffectInstance(MobEffects.GLOWING, 1200));
            }
            player.getCooldowns().addCooldown((Item)this, 300);
            stack.hurtAndBreak(3, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

