/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;

public class DivineSwordItem
extends SwordtemberItem
implements SwordActionHaverServer {
    public DivineSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.NETHERITE, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.NETHERITE, (int)3, (float)-2.4f)));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        boolean ready = !user.getCooldowns().isOnCooldown((Item)this);
        ItemStack handStack = user.getItemInHand(hand);
        if (world instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)world;
            if (ready) {
                user.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 120));
                user.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 120));
                user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 120));
                user.getCooldowns().addCooldown((Item)this, 2400);
                return InteractionResultHolder.success((Object)handStack);
            }
        }
        return ready ? InteractionResultHolder.success((Object)handStack) : InteractionResultHolder.pass((Object)handStack);
    }

    @Override
    public boolean doSwordAction(Player user, ItemStack swordStack) {
        boolean ready;
        boolean bl = ready = !user.getCooldowns().isOnCooldown((Item)this);
        if (ready) {
            user.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 2));
            user.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 300, 5));
            user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 300, 3));
            user.getCooldowns().addCooldown((Item)this, 1200);
        }
        return ready;
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.YELLOW);
    }
}

