/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class PotionSwordItem
extends SwordtemberItem {
    public PotionSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.IRON, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.IRON, (int)3, (float)-2.4f)));
    }

    public ItemStack tryFillSword(ItemStack swordStack, ItemStack fillStack, boolean shouldDecrement) {
        if (swordStack.getItem() != this) {
            return fillStack;
        }
        if (swordStack.has(DataComponents.POTION_CONTENTS)) {
            return ItemStack.EMPTY;
        }
        if (fillStack.getItem() != Items.POTION) {
            return ItemStack.EMPTY;
        }
        if (!fillStack.has(DataComponents.POTION_CONTENTS)) {
            return ItemStack.EMPTY;
        }
        PotionContents potionContents = (PotionContents)fillStack.get(DataComponents.POTION_CONTENTS);
        swordStack.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        swordStack.set(SwordsModComponents.POTION_HITS, (Object)5);
        if (shouldDecrement) {
            fillStack.shrink(1);
        }
        return Items.GLASS_BOTTLE.getDefaultInstance();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        InteractionHand otherHand;
        ItemStack otherHandStack;
        ItemStack swordStack = user.getItemInHand(hand);
        ItemStack resultStack = this.tryFillSword(swordStack, otherHandStack = user.getItemInHand(otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), !user.getAbilities().instabuild);
        if (resultStack.isEmpty()) {
            return InteractionResultHolder.pass((Object)swordStack);
        }
        RandomSource random = world.getRandom();
        world.playSound(null, user.blockPosition(), SoundEvents.BREWING_STAND_BREW, SoundSource.PLAYERS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 2.0f);
        if (otherHandStack.isEmpty()) {
            user.setItemInHand(otherHand, resultStack);
        } else if (!user.getAbilities().instabuild) {
            user.addItem(resultStack);
        }
        return InteractionResultHolder.success((Object)swordStack);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        block3: {
            block4: {
                int hitsLeft;
                block5: {
                    if (!stack.has(DataComponents.POTION_CONTENTS)) break block3;
                    PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    hitsLeft = (Integer)stack.getOrDefault(SwordsModComponents.POTION_HITS, (Object)0);
                    if (hitsLeft > 0) {
                        potionContents.forEachEffect(effect -> {
                            MobEffectInstance lesserInstance = new MobEffectInstance(effect.getEffect(), Math.round((float)effect.getDuration() / 5.0f), effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), effect.showIcon());
                            target.addEffect(lesserInstance, (Entity)attacker);
                        });
                    }
                    if (hitsLeft - 1 <= 0) break block4;
                    if (!(attacker instanceof Player)) break block5;
                    Player player = (Player)attacker;
                    if (player.getAbilities().instabuild) break block3;
                }
                stack.set(SwordsModComponents.POTION_HITS, (Object)(hitsLeft - 1));
                break block3;
            }
            stack.remove(SwordsModComponents.POTION_HITS);
            stack.remove(DataComponents.POTION_CONTENTS);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(6925808);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (stack.has(DataComponents.POTION_CONTENTS)) {
            PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            ArrayList potionTooltip = new ArrayList();
            potionContents.addPotionTooltip(potionTooltipLine -> potionTooltip.add(potionTooltipLine), 1.0f, context.tickRate());
            tooltip.addAll(1, potionTooltip);
        }
    }
}

