/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;

public class PortalSwordItem
extends SwordtemberItem
implements SwordActionHaverServer {
    public static final Tier OBSIDIAN_MATERIAL = new ClassyToolMaterial(750, 7.0f, 2.5f, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 16, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN}));

    public PortalSwordItem(Item.Properties itemSettings) {
        super(OBSIDIAN_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)OBSIDIAN_MATERIAL, (int)3, (float)-2.4f)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(11489251);
    }

    @Override
    public boolean doSwordAction(Player player, ItemStack swordStack) {
        ServerLevel sWorld;
        block6: {
            block5: {
                Level level = player.level();
                if (!(level instanceof ServerLevel)) break block5;
                sWorld = (ServerLevel)level;
                if (SwordsMod.canBeDestructive(player, null)) break block6;
            }
            return false;
        }
        DimensionTransition teleportTarget = PortalSwordItem.createTeleportTarget(sWorld, (Entity)player, player.blockPosition());
        if (teleportTarget != null) {
            ServerLevel otherWorld = teleportTarget.newLevel();
            if (sWorld.getServer().isLevelEnabled((Level)otherWorld) && (otherWorld.dimension() == sWorld.dimension() || player.canChangeDimensions((Level)sWorld, (Level)otherWorld))) {
                player.changeDimension(teleportTarget);
            }
        }
        return true;
    }

    @Nullable
    public static DimensionTransition createTeleportTarget(ServerLevel initialWorld, Entity entity, BlockPos pos) {
        ResourceKey registryKey = initialWorld.dimension() == Level.NETHER ? Level.OVERWORLD : Level.NETHER;
        ServerLevel otherWorld = initialWorld.getServer().getLevel(registryKey);
        if (otherWorld == null) {
            return null;
        }
        if (!(entity instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)entity;
        boolean isNether = otherWorld.dimension() == Level.NETHER;
        WorldBorder worldBorder = otherWorld.getWorldBorder();
        double coordScale = DimensionType.getTeleportationScale((DimensionType)initialWorld.dimensionType(), (DimensionType)otherWorld.dimensionType());
        BlockPos scaledPos = worldBorder.clampToBounds(entity.getX() * coordScale, Math.clamp(entity.getY(), (double)(otherWorld.getMinBuildHeight() + 1), (double)(otherWorld.getMaxBuildHeight() - 1)), entity.getZ() * coordScale);
        DimensionTransition.PostDimensionTransition postDimensionTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET).then(entTeleported -> {
            BlockPos underPos;
            BlockPos headPos;
            BlockState headState;
            BlockState baseState = otherWorld.getBlockState(scaledPos);
            if (baseState.isSuffocating((BlockGetter)otherWorld, scaledPos) && otherWorld.mayInteract((Player)player, scaledPos) && baseState.getBlock().defaultDestroyTime() > 0.0f) {
                otherWorld.destroyBlock(scaledPos, true, (Entity)player);
            }
            if ((headState = otherWorld.getBlockState(headPos = scaledPos.relative(Direction.UP))).isSuffocating((BlockGetter)otherWorld, headPos) && otherWorld.mayInteract((Player)player, headPos) && headState.getBlock().defaultDestroyTime() > 0.0f) {
                otherWorld.destroyBlock(headPos, true, (Entity)player);
            }
            if (otherWorld.getBlockState(underPos = scaledPos.relative(Direction.DOWN)).isAir() && otherWorld.mayInteract((Player)player, underPos)) {
                otherWorld.setBlockAndUpdate(underPos, isNether ? Blocks.NETHERRACK.defaultBlockState() : Blocks.DIRT.defaultBlockState());
            }
        });
        return new DimensionTransition(otherWorld, scaledPos.getCenter(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), postDimensionTransition);
    }
}

