/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.utils.BFSHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class IceSwordItem
extends SwordtemberItem
implements SwordActionHaverServer {
    public static final Tier ICE_MATERIAL = new ClassyToolMaterial(1000, 7.5f, 1.5f, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ICE}));
    public static final ResourceLocation ICE_SWORD_NO_BURN_MODIFIER = SwordsMod.id("iceswordnoburn");
    private static final Map<Block, BlockState> FREEZE_MAP = new HashMap<Block, BlockState>();

    public IceSwordItem(Item.Properties itemSettings) {
        super(ICE_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)ICE_MATERIAL, (int)3, (float)-2.4f).withModifierAdded(Attributes.BURNING_TIME, new AttributeModifier(ICE_SWORD_NO_BURN_MODIFIER, -10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)));
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            return attacker.isFullyFrozen() ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level world = attacker.level();
        RandomSource random = world.getRandom();
        world.playSound(null, attacker.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.PLAYERS, 0.5f, (random.nextFloat() - random.nextFloat()) * 0.2f + 2.0f);
        target.setIsInPowderSnow(true);
        target.setTicksFrozen(Math.max(380, target.getTicksFrozen()));
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        RandomSource random = world.getRandom();
        if (!player.getCooldowns().isOnCooldown((Item)this)) {
            Snowball snowball = new Snowball(this, player.level(), (LivingEntity)player){

                protected void onHitEntity(EntityHitResult entityHitResult) {
                    super.onHitEntity(entityHitResult);
                    Entity entity = entityHitResult.getEntity();
                    entity.setIsInPowderSnow(true);
                    entity.setTicksFrozen(Math.max(250, entity.getTicksFrozen()));
                }
            };
            snowball.setDeltaMovement(player.getLookAngle().scale(1.5));
            Vec3 lookVec = player.getLookAngle();
            snowball.setPos(player.position().add(lookVec.x, 1.4, lookVec.z));
            player.level().addFreshEntity((Entity)snowball);
            player.getCooldowns().addCooldown((Item)this, 30);
            stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            world.playSound(null, player.blockPosition(), SoundEvents.POWDER_SNOW_PLACE, SoundSource.BLOCKS, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public boolean doSwordAction(Player player, ItemStack swordStack) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        boolean canBeDestructive = SwordsMod.canBeDestructive(player, null);
        Level world = player.level();
        Vec3 lookVec = player.getLookAngle();
        RandomSource random = world.getRandom();
        List nearbyEnts = world.getEntities((Entity)player, new AABB(player.blockPosition()).inflate(6.0));
        for (Entity target : nearbyEnts) {
            target.setIsInPowderSnow(true);
            target.setTicksFrozen(Math.max(460, target.getTicksFrozen()));
            world.playSound(null, player.blockPosition(), SoundEvents.BUCKET_EMPTY_POWDER_SNOW, SoundSource.PLAYERS, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        }
        int numFrozen = 0;
        if (canBeDestructive) {
            Map<BlockPos, Integer> iceZone = BFSHelper.runBFS(world, player.blockPosition(), (worldArg, pos, dist) -> {
                Block block = worldArg.getBlockState(pos).getBlock();
                return dist < 2 || FREEZE_MAP.containsKey(block);
            }, 4, true);
            numFrozen = iceZone.keySet().size();
            for (BlockPos fPos : iceZone.keySet()) {
                Block fBlock = world.getBlockState(fPos).getBlock();
                BlockState newState = FREEZE_MAP.get(fBlock);
                if (newState == null) continue;
                world.setBlockAndUpdate(fPos, newState);
            }
        }
        player.getCooldowns().addCooldown((Item)this, Math.min(numFrozen, 80) + Math.min(nearbyEnts.size() * 20, 300));
        world.playSound(null, player.blockPosition(), SoundEvents.POWDER_SNOW_HIT, SoundSource.PLAYERS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        swordStack.hurtAndBreak(3 + Math.min(nearbyEnts.size() * 2, 12), (LivingEntity)player, player.getMainHandItem() == swordStack ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        return true;
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(0x5EEFFF);
    }

    static {
        FREEZE_MAP.put(Blocks.WATER, Blocks.FROSTED_ICE.defaultBlockState());
        FREEZE_MAP.put(Blocks.FROSTED_ICE, Blocks.ICE.defaultBlockState());
        FREEZE_MAP.put(Blocks.ICE, Blocks.PACKED_ICE.defaultBlockState());
        FREEZE_MAP.put(Blocks.PACKED_ICE, Blocks.BLUE_ICE.defaultBlockState());
        FREEZE_MAP.put(Blocks.LAVA, Blocks.OBSIDIAN.defaultBlockState());
    }
}

