/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.render.FakeGhostPlayerManager;
import java.util.Set;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class EchoSwordItem
extends SwordtemberItem {
    public static final Tier ECHO_MATERIAL = new ClassyToolMaterial(2500, 5.0f, 4.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 18, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD}));

    public EchoSwordItem(Item.Properties itemSettings) {
        super(ECHO_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)ECHO_MATERIAL, (int)3, (float)-2.0f)));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide()) {
            FakeGhostPlayerManager.makeFakePlayer();
        }
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (world.isClientSide()) {
            Vec3 tpPos = EchoSwordItem.raycastForGhost(world, user);
            FakeGhostPlayerManager.setPlayerPosition(tpPos);
            FakeGhostPlayerManager.getGhostPlayer().ifPresent(ghost -> {
                ghost.lookAt(EntityAnchorArgument.Anchor.FEET, ghost.getEyePosition().subtract(user.getEyePosition()).add(ghost.getEyePosition()));
                ghost.lookAt(EntityAnchorArgument.Anchor.EYES, user.getLookAngle().add(ghost.getEyePosition()));
                ghost.updatePlayerPose();
                if (ghost.canPlayerFitWithinBlocksAndEntitiesWhen(user.getPose())) {
                    ghost.setPose(user.getPose());
                }
            });
        }
        user.setLastEchoUsage(user.tickCount);
        super.onUseTick(world, user, stack, remainingUseTicks);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (world.isClientSide()) {
            FakeGhostPlayerManager.removePlayer();
        } else if (world instanceof ServerLevel) {
            int i;
            ServerLevel sWorld = (ServerLevel)world;
            Vec3 tpPos = EchoSwordItem.raycastForGhost(world, user);
            world.playSound(null, user.blockPosition(), SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.PLAYERS, 50.0f, user.getRandom().nextFloat() * 0.2f + 0.5f);
            for (i = 0; i < 5; ++i) {
                sWorld.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, user.getX() + user.getRandom().nextDouble() - 0.5, user.getY() + user.getRandom().nextDouble(), user.getZ() + user.getRandom().nextDouble() - 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
            user.teleportTo(sWorld, tpPos.x, tpPos.y, tpPos.z, Set.of(), user.getYRot(), user.getXRot());
            world.playSound(null, user.blockPosition(), SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.PLAYERS, 100.0f, user.getRandom().nextFloat() * 0.2f + 0.5f);
            for (i = 0; i < 10; ++i) {
                sWorld.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, user.getX() + user.getRandom().nextDouble() - 0.5, user.getY() + user.getRandom().nextDouble(), user.getZ() + user.getRandom().nextDouble() - 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        super.releaseUsing(stack, world, user, remainingUseTicks);
    }

    public static Vec3 raycastForGhost(Level world, LivingEntity user) {
        BlockHitResult upHit;
        BlockHitResult hit = world.clip(new ClipContext(user.getEyePosition(), user.getLookAngle().scale(32.0).add(user.getEyePosition()), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.of((Entity)user)));
        double idealHeight = user.getDimensions(user.isShiftKeyDown() ? Pose.CROUCHING : Pose.STANDING).height();
        double smallestFitHeight = user.getDimensions(Pose.SWIMMING).height();
        Vec3 anchorPos = user.getLookAngle().scale(16.0).add(user.getEyePosition());
        if (hit.getType() == HitResult.Type.BLOCK) {
            if (hit.getDirection().getAxis().isVertical()) {
                anchorPos = hit.getLocation();
            } else if (hit.getDirection().getAxis().isHorizontal()) {
                Vec3i dirVec = hit.getDirection().getNormal();
                Vec3 normVec = new Vec3((double)dirVec.getX(), (double)dirVec.getY(), (double)dirVec.getZ());
                BlockHitResult downHit = world.clip(new ClipContext(hit.getLocation().add(0.0, 0.5, 0.0).add(normVec.scale(0.01)), hit.getLocation().add(normVec.scale(-0.1)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.of((Entity)user)));
                anchorPos = downHit.getType() == HitResult.Type.BLOCK && downHit.getDirection() == Direction.UP && !downHit.isInside() ? downHit.getLocation() : hit.getLocation().add(normVec.scale((double)(user.getBbWidth() / 2.0f)));
            } else {
                anchorPos = hit.getLocation();
            }
        }
        if ((upHit = world.clip(new ClipContext(anchorPos, anchorPos.add(0.0, idealHeight - 1.0E-6, 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.of((Entity)user)))).getType() == HitResult.Type.BLOCK) {
            BlockHitResult backDownHit = world.clip(new ClipContext(upHit.getLocation(), upHit.getLocation().add(0.0, -idealHeight, 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.of((Entity)user)));
            if (backDownHit.getType() == HitResult.Type.BLOCK) {
                return backDownHit.getLocation();
            }
            return upHit.getLocation().subtract(0.0, idealHeight, 0.0);
        }
        return anchorPos;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (world.isClientSide) {
            FakeGhostPlayerManager.removePlayer();
        }
        return super.finishUsingItem(stack, world, user);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        Player player;
        if (user instanceof Player && (player = (Player)user).getCooldowns().isOnCooldown((Item)this)) {
            return 0;
        }
        return 72000;
    }

    public boolean useOnRelease(ItemStack stack) {
        return true;
    }
}

