/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.registry.SwordsModKeybinds;
import com.samsthenerd.monthofswords.registry.SwordsModNetworking;
import com.samsthenerd.monthofswords.render.GhostifyTexture;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public class SwordsModClient {
    public static void init() {
        SwordsModClient.setupModelPreds();
        SwordsModClient.setupColorProviders();
        SwordsModKeybinds.init();
        SwordsModClient.registerEntityRenderers();
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.register((player, hand) -> NetworkManager.sendToServer((CustomPacketPayload)new SwordsModNetworking.SwordLeftClickPayload(hand == InteractionHand.MAIN_HAND)));
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)((ResourceManagerReloadListener)GhostifyTexture::clearTextures));
    }

    private static void setupModelPreds() {
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)SwordsModItems.FLORAL_SWORD.get()), (ResourceLocation)SwordsMod.id("floweryness"), (itemStack, clientWorld, livingEntity, i) -> (float)itemStack.getDamageValue() / (float)itemStack.getMaxDamage());
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)SwordsModItems.POTION_SWORD.get()), (ResourceLocation)SwordsMod.id("potionlevel"), (itemStack, clientWorld, livingEntity, i) -> (float)((Integer)itemStack.getOrDefault(SwordsModComponents.POTION_HITS, (Object)0)).intValue() / 5.0f);
    }

    private static void setupColorProviders() {
        ColorHandlerRegistry.registerItemColors((stack, layer) -> {
            if (stack.has(DataComponents.POTION_CONTENTS) && layer == 1) {
                PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                return potionContents.getColor();
            }
            return -1;
        }, (Supplier[])new Supplier[]{SwordsModItems.POTION_SWORD});
    }

    private static void registerEntityRenderers() {
    }
}

