package com.samsthenerd.monthofswords.tooltips;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.crafting.Recipe;

public record RecipeTooltipData(Recipe<?> rec) implements TooltipComponent {
    public static final Codec<RecipeTooltipData> CODEC = RecordCodecBuilder.create(instance ->
        instance.group(
            Recipe.CODEC.fieldOf("rec").forGetter(RecipeTooltipData::rec)
            ).apply(instance, RecipeTooltipData::new)
    );
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeTooltipData> PACKET_CODEC = StreamCodec.composite(
        Recipe.STREAM_CODEC, RecipeTooltipData::rec,
        RecipeTooltipData::new
    );
}
