package com.samsthenerd.monthofswords.registry;

import com.mojang.blaze3d.platform.InputConstants;
import com.samsthenerd.monthofswords.items.SwordActionHaverClient;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.world.item.ItemStack;

public class SwordsModKeybinds {
    public static final KeyMapping SWORDS_KEY = new KeyMapping(
            "key.swordsmod.action", // The translation key of the name shown in the Controls screen
            InputConstants.Type.KEYSYM, // This key mapping is for Keyboards by default
            InputConstants.KEY_I, // The default keycode
            "category.swordsmod.swordscat" // The category translation key used to categorize in the Controls screen
    );

    public static void init(){
        KeyMappingRegistry.register(SWORDS_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (SWORDS_KEY.consumeClick()) {
                boolean handled = false;
                if(minecraft.player == null) continue;
                for(ItemStack handItem : minecraft.player.getHandSlots()){
                    if(handItem.getItem() instanceof SwordActionHaverClient clientActionHaver){
                        if(clientActionHaver.doSwordActionClient(handItem)){
                            handled = true;
                            break;
                        }
                    }
                }
                if(!handled){
                    NetworkManager.sendToServer(new SwordsModNetworking.SwordActionPayload());
                }
            }
        });
    }
}
