package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import org.joml.Vector3f;

import java.util.function.UnaryOperator;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WovenSwordItem extends SwordtemberItem {

    public WovenSwordItem(Item.Properties itemSettings) {
        super(Tiers.DIAMOND, itemSettings.attributes(
            SwordItem.createAttributes(Tiers.DIAMOND, 5, -2.4f))
        );
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return (style) -> style.withColor(0xFCCBE6);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        attacker.level().playSound(null, attacker.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME,
            SoundSource.PLAYERS, 100f, attacker.getRandom().nextFloat() * 0.4f + 0.8f);
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if(user.getCooldowns().isOnCooldown(this)) return InteractionResultHolder.pass(stack);
        if(user instanceof ServerPlayer sPlayer){
            world.playSound(null, sPlayer.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME,
                SoundSource.PLAYERS, 100f, user.getRandom().nextFloat() * 0.4f + 0.8f);
            Vec3 vel = user.getLookAngle();
            user.push(vel);
            user.hurtMarked = true;
            user.getCooldowns().addCooldown(this, 1000);
            ((LivingEntDuck)user).makeDashTransgenderly();
        }
        return InteractionResultHolder.sidedSuccess(stack, true);
    }

    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        if(damageSource.getEntity() instanceof LivingEntDuck attacker){
            return attacker.isDashingTransgenderly() ? 4 : 0;
        }
        return 0;
    }

    public static final Vector3f TRANS_BLUE_COLOR = new Vector3f(80f/256, 190f/256, 241f/256);
    public static final Vector3f TRANS_PINK_COLOR = new Vector3f(252f/256, 203f/256, 230f/256);

    public static void makeTransParticles(ServerPlayer player){
        for(int i = 0; i < 10; i++){
            player.serverLevel().sendParticles(
                new DustParticleOptions(player.getRandom().nextBoolean() ? TRANS_BLUE_COLOR : TRANS_PINK_COLOR, 1),
                player.getX()+player.getRandom().nextDouble(),
                player.getY()+player.getRandom().nextDouble(),
                player.getZ()+player.getRandom().nextDouble(),
                1,
                0, 0, 0, 0);
        }
    }
}
