package com.samsthenerd.monthofswords.items;

import net.minecraft.item.*;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import java.util.function.UnaryOperator;

public class PoisonDaggerItem extends SwordtemberItem{

    public static final Tier POISONOUS_MATERIAL = new ClassyToolMaterial(200, 7f, 1f,
        BlockTags.INCORRECT_FOR_STONE_TOOL, 16, () -> Ingredient.of(Items.SPIDER_EYE));

    public PoisonDaggerItem(Item.Properties itemSettings) {
        super(POISONOUS_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(POISONOUS_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.addEffect(new MobEffectInstance(MobEffects.POISON, 20*20, 3));
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0x476e2c);
    }
}
