package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.render.FakeGhostPlayerManager;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import net.minecraft.commands.arguments.EntityAnchorArgument.Anchor;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.item.*;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ClipContext.Block;
import net.minecraft.world.level.ClipContext.Fluid;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult.Type;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import java.util.Set;

public class EchoSwordItem extends SwordtemberItem {

    public static final Tier ECHO_MATERIAL = new ClassyToolMaterial(2500, 5f, 4f,
        BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 18, () -> Ingredient.of(Items.ECHO_SHARD));


    public EchoSwordItem(Item.Properties itemSettings) {
        super(ECHO_MATERIAL, itemSettings.attributes(
                SwordItem.createAttributes(ECHO_MATERIAL, 3, -2f)
            )
        );
    }

//    @Override
//    public boolean postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
////        target.addStatusEffect(new StatusEffectInstance(
////            SwordsModStatusEffects.getEffect(SwordsModStatusEffects.DISPLACED),
////            20*5
////        ));
//        return super.postHit(stack, target, attacker);
//    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if(world.isClientSide()){
            FakeGhostPlayerManager.makeFakePlayer();
        }
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume(itemStack);
    }

    @Override
    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if(world.isClientSide()){
            Vec3 tpPos = raycastForGhost(world, user);
            FakeGhostPlayerManager.setPlayerPosition(tpPos);
            FakeGhostPlayerManager.getGhostPlayer().ifPresent(ghost -> {

                ghost.lookAt(Anchor.FEET,
                    ghost.getEyePosition().subtract(user.getEyePosition()).add(ghost.getEyePosition()));
                ghost.lookAt(Anchor.EYES, user.getLookAngle().add(ghost.getEyePosition()));
                ghost.updatePlayerPose();
                if(ghost.canPlayerFitWithinBlocksAndEntitiesWhen(user.getPose())){
                    ghost.setPose(user.getPose());
                }
            });
        }
        ((LivingEntDuck)user).setLastEchoUsage(user.tickCount);
        super.onUseTick(world, user, stack, remainingUseTicks);
    }

    @Override
    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if(world.isClientSide()){
            FakeGhostPlayerManager.removePlayer();
        } else if(world instanceof ServerLevel sWorld){
            Vec3 tpPos = raycastForGhost(world, user);
            world.playSound(null, user.blockPosition(), SoundEvents.SCULK_BLOCK_CHARGE,
                SoundSource.PLAYERS, 50f,
                user.getRandom().nextFloat() * 0.2f + 0.5f);

            for(int i = 0; i < 5; i++){
                sWorld.sendParticles(
                    ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS,
                    user.getX()+user.getRandom().nextDouble()-0.5,
                    user.getY()+user.getRandom().nextDouble(),
                    user.getZ()+user.getRandom().nextDouble()-0.5,
                    1,
                    0, 0, 0, 0
                );
            }

            user.teleportTo(sWorld, tpPos.x, tpPos.y, tpPos.z, Set.of(), user.getYRot(), user.getXRot());

            // should attack nearby ents? idk
//            var nearEnts = sWorld.getOtherEntities(user, user.getBoundingBox());
//            for(Entity ent : nearEnts){
//                ent.damage(DamageSources)
//            }

            world.playSound(null, user.blockPosition(), SoundEvents.SCULK_BLOCK_CHARGE,
                SoundSource.PLAYERS, 100f,
                user.getRandom().nextFloat() * 0.2f + 0.5f);

            for(int i = 0; i < 10; i++){
                sWorld.sendParticles(
                    ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS,
                    user.getX()+user.getRandom().nextDouble()-0.5,
                    user.getY()+user.getRandom().nextDouble(),
                    user.getZ()+user.getRandom().nextDouble()-0.5,
                    1,
                    0, 0, 0, 0
                );
            }
        }
        super.releaseUsing(stack, world, user, remainingUseTicks);
    }

    public static Vec3 raycastForGhost(Level world, LivingEntity user){
        BlockHitResult hit = world.clip(new ClipContext(
            user.getEyePosition(),
            user.getLookAngle().scale(32).add(user.getEyePosition()),
            Block.VISUAL,
            Fluid.NONE,
            CollisionContext.of(user)
        ));
        // height we should aim for, but we'd maybe fit into smaller
        double idealHeight = user.getDimensions(user.isShiftKeyDown() ? Pose.CROUCHING : Pose.STANDING).height();
        double smallestFitHeight = user.getDimensions(Pose.SWIMMING).height();

        Vec3 anchorPos = user.getLookAngle().scale(16).add(user.getEyePosition());
        if(hit.getType() == Type.BLOCK){
            if(hit.getDirection().getAxis().isVertical()){
                anchorPos =  hit.getLocation();
            } else if(hit.getDirection().getAxis().isHorizontal()){
                Vec3i dirVec = hit.getDirection().getNormal();
                Vec3 normVec = new Vec3(dirVec.getX(), dirVec.getY(), dirVec.getZ());
                BlockHitResult downHit = world.clip(new ClipContext(
                    hit.getLocation().add(0, 0.5, 0).add(normVec.scale(0.01)),
                    hit.getLocation().add(normVec.scale(-0.1)),
                    Block.VISUAL,
                    Fluid.NONE,
                    CollisionContext.of(user)
                ));
                if(downHit.getType() == Type.BLOCK && downHit.getDirection() == Direction.UP && !downHit.isInside()){
                    anchorPos = downHit.getLocation();
                } else {
                    anchorPos = hit.getLocation().add(normVec.scale(user.getBbWidth()/2));
                }
            } else {
                anchorPos = hit.getLocation();
            }
        }
        // see if the head will be in something and if we can fix that
        BlockHitResult upHit = world.clip(new ClipContext(
           anchorPos, anchorPos.add(0, idealHeight - 1E-6, 0),
            Block.VISUAL, Fluid.NONE, CollisionContext.of(user)
        ));
        if(upHit.getType() == Type.BLOCK){
            // head is hitting something
            BlockHitResult backDownHit = world.clip(new ClipContext(
               upHit.getLocation(), upHit.getLocation().add(0, -idealHeight, 0),
                Block.VISUAL, Fluid.NONE, CollisionContext.of(user)
            ));
            if(backDownHit.getType() == Type.BLOCK){
                // there's a surface somewhere between here and our ideal height, put self there
                return backDownHit.getLocation();
            } else {
                // no surface, just plop down at the height we're at
                return upHit.getLocation().subtract(0, idealHeight, 0);
            }
        }
        return anchorPos;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if(world.isClientSide){
            FakeGhostPlayerManager.removePlayer();
        }
        return super.finishUsingItem(stack, world, user);
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        if(user instanceof Player player && player.getCooldowns().isOnCooldown(this)) return 0;
        return 72000;
    }

    @Override
    public boolean useOnRelease(ItemStack stack) {
        return true;
    }
}
