package com.samsthenerd.monthofswords.items;

import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class ClassyToolMaterial implements Tier {
    private int durability;
    private float miningSpeedMult;
    private float damage;
    private TagKey<Block> inverseTag; // whatever that means
    private int enchantability;
    private Supplier<Ingredient> repairIngredient;


    public ClassyToolMaterial(int dur, float miningSpeed, float damage, TagKey<Block> invTag, int enchantability, Supplier<Ingredient> repairIngredient){
        this.durability = dur;
        this.miningSpeedMult = miningSpeed;
        this.damage = damage;
        this.inverseTag = invTag;
        this.enchantability = enchantability;
        this.repairIngredient = repairIngredient;
    }

    public int getUses(){return this.durability; }

    public float getSpeed(){ return this.miningSpeedMult; }

    public float getAttackDamageBonus(){ return this.damage; }

    public TagKey<Block> getIncorrectBlocksForDrops(){ return this.inverseTag; }

    public int getEnchantmentValue(){ return this.enchantability; }

    public Ingredient getRepairIngredient(){ return this.repairIngredient.get(); }
}
