package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.screen.ScreenLaunderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CalendarItem extends DescriptableItem {
    public CalendarItem(Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if(world.isClientSide()){
            ScreenLaunderer.openCalendarScreen();
        }
        return InteractionResultHolder.sidedSuccess(user.getItemInHand(hand), true);
    }
}
