/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.tooltips;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.mixins.MixinSmithingTransformRecipeAccessor;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

public record RecipeTooltipComponent(RecipeTooltipData data) implements ClientTooltipComponent
{
    public static final ResourceLocation CRAFTING_BACKGROUND = SwordsMod.id("textures/gui/crafting_background.png");
    public static final ResourceLocation SMITHING_BACKGROUND = SwordsMod.id("textures/gui/smithing_background.png");

    public int getHeight() {
        return 83;
    }

    public int getWidth(Font textRenderer) {
        return 150;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        Recipe<?> recipe = this.data.rec();
        if (recipe instanceof CraftingRecipe) {
            ShapedRecipe shapedRec;
            CraftingRecipe craftRec = (CraftingRecipe)recipe;
            context.blit(CRAFTING_BACKGROUND, x, y, 100, 0.0f, 0.0f, 146, 83, 256, 256);
            ingrs = craftRec.getIngredients();
            int recWidth = 3;
            int recXOffset = 0;
            if (craftRec instanceof ShapedRecipe && (recWidth = Math.min((shapedRec = (ShapedRecipe)craftRec).getWidth(), 3)) == 1) {
                recXOffset = 1;
            }
            for (int i = 0; i < ingrs.size(); ++i) {
                int ingrX = 18 + (i % recWidth + recXOffset) * 18;
                int ingrY = 15 + i / recWidth * 18;
                ItemStack ingrStack = Arrays.stream(((Ingredient)ingrs.get(i)).getItems()).findFirst().orElse(ItemStack.EMPTY);
                context.renderItem(ingrStack, x + ingrX, y + ingrY);
            }
            context.renderItem(craftRec.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), 112 + x, 33 + y);
        } else {
            SmithingTransformRecipe smithRec;
            ingrs = this.data.rec();
            if (ingrs instanceof SmithingTransformRecipe && (smithRec = (SmithingTransformRecipe)ingrs) instanceof MixinSmithingTransformRecipeAccessor) {
                MixinSmithingTransformRecipeAccessor smithRecAcc = (MixinSmithingTransformRecipeAccessor)smithRec;
                context.blit(SMITHING_BACKGROUND, x, y, 100, 0.0f, 0.0f, 146, 83, 256, 256);
                ingrs = List.of(smithRecAcc.getTemplateIngredient(), smithRecAcc.getBaseIngredient(), smithRecAcc.getAdditionIngredient());
                for (int i = 0; i < ingrs.size(); ++i) {
                    int ingrX = 20 + i * 18;
                    int ingrY = 43 - i;
                    ItemStack ingrStack = Arrays.stream(((Ingredient)ingrs.get(i)).getItems()).findFirst().orElse(ItemStack.EMPTY);
                    context.renderItem(ingrStack, x + ingrX, y + ingrY);
                }
                context.renderItem(smithRec.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), 110 + x, 43 + y);
            }
        }
    }
}

