/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.samsthenerd.monthofswords.mixins.MixinAccessResTexLocation;
import com.samsthenerd.monthofswords.render.PlayerSkinImageDuck;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;

public class GhostifyTexture {
    private static final HashMap<ResourceLocation, ResourceLocation> GHOSTIFIED_TEXTURES = new HashMap();

    public static void clearTextures(ResourceManager resMan) {
        for (ResourceLocation tex : GHOSTIFIED_TEXTURES.values()) {
            Minecraft.getInstance().getTextureManager().release(tex);
        }
        GHOSTIFIED_TEXTURES.clear();
    }

    public static Optional<ResourceLocation> getGhostifiedTexture(ResourceLocation originalTextureId) {
        if (GHOSTIFIED_TEXTURES.containsKey(originalTextureId)) {
            return Optional.of(GHOSTIFIED_TEXTURES.get(originalTextureId));
        }
        AbstractTexture tex = Minecraft.getInstance().getTextureManager().getTexture(originalTextureId);
        return GhostifyTexture.getImageFromTexture(tex).map(img -> {
            NativeImage newImg = new NativeImage(img.getWidth(), img.getHeight(), true);
            int minColor = 255;
            int maxColor = 0;
            for (int x = 0; x < img.getWidth(); ++x) {
                for (int y = 0; y < img.getHeight(); ++y) {
                    int color = img.getPixelRGBA(x, y);
                    int alpha = FastColor.ARGB32.alpha((int)color);
                    if (alpha == 0) {
                        newImg.setPixelRGBA(x, y, 0);
                        continue;
                    }
                    int luminance = (int)(0.2126 * (double)FastColor.ARGB32.red((int)color) + 0.7152 * (double)FastColor.ARGB32.green((int)color) + 0.0722 * (double)FastColor.ARGB32.blue((int)color));
                    minColor = Math.min(luminance, minColor);
                    maxColor = Math.max(luminance, maxColor);
                    int argb = FastColor.ARGB32.color((int)alpha, (int)luminance, (int)luminance, (int)luminance);
                    newImg.setPixelRGBA(x, y, argb);
                }
            }
            int minColorF = minColor;
            int maxColorF = maxColor;
            double r = maxColorF - minColorF;
            newImg.applyToAllPixels(c -> {
                int b = 0xFF & c;
                int bn = (int)((double)(100 * (b - minColorF)) / r) + 155;
                return FastColor.ARGB32.color((int)FastColor.ARGB32.alpha((int)c), (int)bn, (int)bn, (int)bn);
            });
            ResourceLocation newId = ResourceLocation.fromNamespaceAndPath((String)(originalTextureId.getNamespace() + "_monthofswords_ghostified"), (String)(originalTextureId.getPath() + "_monthofswords_ghostified"));
            Minecraft.getInstance().getTextureManager().register(newId, (AbstractTexture)new DynamicTexture(newImg));
            GHOSTIFIED_TEXTURES.put(originalTextureId, newId);
            return newId;
        });
    }

    public static Optional<NativeImage> getImageFromTexture(AbstractTexture texture) {
        HttpTexture psiDuck;
        NativeImage img;
        HttpTexture psTex;
        if (texture instanceof DynamicTexture) {
            DynamicTexture nibTex = (DynamicTexture)texture;
            return Optional.ofNullable(nibTex.getPixels());
        }
        if (texture instanceof HttpTexture && (psTex = (HttpTexture)texture) instanceof PlayerSkinImageDuck && (img = (psiDuck = psTex).mos$getSkinNativeImage()) != null) {
            return Optional.of(img);
        }
        if (texture instanceof SimpleTexture) {
            SimpleTexture resTex = (SimpleTexture)texture;
            return ResLoaderAccessor.loadNativeImage(Minecraft.getInstance().getResourceManager(), resTex);
        }
        return Optional.empty();
    }

    public static class ResLoaderAccessor
    extends SimpleTexture {
        public ResLoaderAccessor(ResourceLocation location) {
            super(location);
        }

        public static Optional<NativeImage> loadNativeImage(ResourceManager resMan, SimpleTexture resTex) {
            try {
                SimpleTexture.TextureImage texData = SimpleTexture.TextureImage.load((ResourceManager)resMan, (ResourceLocation)((MixinAccessResTexLocation)resTex).getLocation());
                return Optional.of(texData.getImage());
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
    }
}

