/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class SwordsModStatusEffects {
    private static final Map<ResourceLocation, MobEffect> effectsMap = new HashMap<ResourceLocation, MobEffect>();
    public static DeferredRegister<MobEffect> STATUS_EFFECTS = DeferredRegister.create((String)"monthofswords", (ResourceKey)Registries.MOB_EFFECT);
    public static final ResourceLocation SMOKE_BOMBED = SwordsModStatusEffects.register(SwordsMod.id("smoke_bombed"), new MobEffect(MobEffectCategory.HARMFUL, 0){}.addAttributeModifier(Attributes.FOLLOW_RANGE, SwordsMod.id("effect.smoke_bombed"), -32.0, AttributeModifier.Operation.ADD_VALUE));
    public static final ResourceLocation FRIEND_OF_BUGS = SwordsModStatusEffects.register(SwordsMod.id("friend_of_bugs"), new FriendOfEntityStatusEffect(ent -> ent.getType().is(EntityTypeTags.ARTHROPOD), 0, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)0, (int)0))));
    public static final ResourceLocation NECROMANCER = SwordsModStatusEffects.register(SwordsMod.id("necromancer"), new FriendOfEntityStatusEffect(ent -> ent.getType().is(EntityTypeTags.UNDEAD), 0));

    public static Holder<MobEffect> getEffect(ResourceLocation id) {
        return STATUS_EFFECTS.getRegistrar().getHolder(id);
    }

    public static ResourceLocation register(ResourceLocation id, MobEffect statusEffect) {
        effectsMap.put(id, statusEffect);
        return id;
    }

    public static void init() {
        STATUS_EFFECTS.register();
        for (Map.Entry<ResourceLocation, MobEffect> entry : effectsMap.entrySet()) {
            STATUS_EFFECTS.register(entry.getKey(), entry::getValue);
        }
    }

    public static class FriendOfEntityStatusEffect
    extends MobEffect {
        public final Predicate<Entity> friendPredicate;
        public static final List<FriendOfEntityStatusEffect> ALL_FRIEND_EFFECTS = new ArrayList<FriendOfEntityStatusEffect>();

        public FriendOfEntityStatusEffect(Predicate<Entity> friendPredicate, int color, ParticleOptions particle) {
            super(MobEffectCategory.BENEFICIAL, color, particle);
            this.friendPredicate = friendPredicate;
            ALL_FRIEND_EFFECTS.add(this);
        }

        public FriendOfEntityStatusEffect(Predicate<Entity> friendPredicate, int color) {
            this(friendPredicate, color, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0));
        }
    }
}

