/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects;
import com.samsthenerd.monthofswords.utils.FollowLeaderGoal;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class InfestationSwordItem
extends SwordtemberItem {
    public static final Tier INFESTATION_MATERIAL = new ClassyToolMaterial(500, 5.0f, 3.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}));

    public InfestationSwordItem(Item.Properties itemSettings) {
        super(INFESTATION_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)INFESTATION_MATERIAL, (int)3, (float)-2.4f)));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (selected && entity instanceof LivingEntity) {
            LivingEntity livEnt = (LivingEntity)entity;
            if (!world.isClientSide()) {
                livEnt.addEffect(new MobEffectInstance(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.FRIEND_OF_BUGS), 300));
            }
        }
    }

    public static List<Entity> findEnemies(Vec3 nearPos, ServerPlayer owner) {
        List enemyList = owner.serverLevel().getEntities(null, AABB.ofSize((Vec3)nearPos, (double)16.0, (double)8.0, (double)16.0), ent -> {
            Monster hent;
            return ent instanceof Monster && (hent = (Monster)ent).isAlive() && (hent.getTarget() == owner || hent.getTarget() instanceof Silverfish);
        });
        enemyList.sort(Comparator.comparing(ent -> ent.position().distanceTo(nearPos)));
        return enemyList;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof ServerPlayer) {
            final ServerPlayer sPlayer = (ServerPlayer)user;
            int timeHeld = 72000 - remainingUseTicks;
            int fishCount = Math.clamp((long)(timeHeld / 5), 1, 6);
            sPlayer.getCooldowns().addCooldown((Item)this, 20 * fishCount * 3);
            List<Entity> enemyList = InfestationSwordItem.findEnemies(sPlayer.position(), sPlayer);
            for (int i = 0; i < fishCount; ++i) {
                var bug = new Silverfish(this, EntityType.SILVERFISH, sPlayer.level()){

                    public void setTarget(@Nullable LivingEntity target) {
                        if (target == sPlayer) {
                            return;
                        }
                        super.setTarget(target);
                    }

                    public void tick() {
                        int lastFight;
                        int peaceTime;
                        LivingEntity tgt = this.getTarget();
                        if (tgt != null && !tgt.isAlive()) {
                            List<Entity> enemyList = InfestationSwordItem.findEnemies(this.position(), sPlayer);
                            if (!enemyList.isEmpty()) {
                                Entity target = enemyList.get(sPlayer.getRandom().nextIntBetweenInclusive(0, Math.min(enemyList.size() - 1, 3)));
                                this.setTarget((LivingEntity)((Monster)target));
                            } else {
                                this.setTarget(null);
                            }
                        }
                        if (tgt == null && (peaceTime = this.tickCount - (lastFight = Math.max(this.getLastHurtByMobTimestamp(), this.getLastHurtMobTimestamp()))) > 400 && lastFight != 0 && (double)sPlayer.getRandom().nextFloat() < 0.003) {
                            this.spawnAnim();
                            this.discard();
                        }
                        super.tick();
                    }

                    public boolean killedEntity(ServerLevel world, LivingEntity other) {
                        return super.killedEntity(world, other);
                    }

                    protected void registerGoals() {
                        this.goalSelector.addGoal(4, (Goal)new FollowLeaderGoal((PathfinderMob)this, (LivingEntity)sPlayer, 1.0, 4.0f, 2.0f));
                        super.registerGoals();
                        Predicate<Goal> isWander = goal -> goal instanceof RandomStrollGoal;
                        this.goalSelector.removeAllGoals(isWander);
                    }
                };
                bug.setPos(sPlayer.position());
                sPlayer.serverLevel().addFreshEntity((Entity)bug);
                if (enemyList.isEmpty()) continue;
                Entity target = enemyList.get(sPlayer.getRandom().nextIntBetweenInclusive(0, Math.min(enemyList.size() - 1, 3)));
                bug.setTarget((LivingEntity)((Monster)target));
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        Player player;
        if (user instanceof Player && (player = (Player)user).getCooldowns().isOnCooldown((Item)this)) {
            return 0;
        }
        return 72000;
    }

    public boolean useOnRelease(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        LivingEntity livEnt;
        if (target instanceof LivingEntity && (livEnt = (LivingEntity)target).getType().is(EntityTypeTags.ARTHROPOD)) {
            return -100.0f;
        }
        if (target instanceof LivingEntity && (livEnt = (LivingEntity)target).hasEffect(MobEffects.INFESTED)) {
            return 2.0f;
        }
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            if (!target.getType().is(EntityTypeTags.ARTHROPOD)) {
                List bugsList = sWorld.getEntities((Entity)target, AABB.ofSize((Vec3)target.position(), (double)16.0, (double)8.0, (double)16.0), ent -> ent.getType().is(EntityTypeTags.ARTHROPOD) && ent instanceof Monster);
                for (Entity bug : bugsList) {
                    Monster hostEnt;
                    LivingEntity existTarget;
                    if (!(bug instanceof Monster) || (existTarget = (hostEnt = (Monster)bug).getTarget()) != null && existTarget.isAlive() && !(target.distanceTo(bug) - existTarget.distanceTo(bug) < 2.0f) && !((double)attacker.getRandom().nextFloat() < 0.2)) continue;
                    hostEnt.setTarget(target);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.GRAY);
    }
}

