/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DuelingSwordItem
extends SwordtemberItem {
    public DuelingSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.IRON, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.IRON, (int)3, (float)-2.4f)));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (user.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Player player;
        ItemStack swordStack = damageSource.getWeaponItem();
        if (swordStack == null) {
            return 0.0f;
        }
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown((Item)this)) {
            return baseAttackDamage * 0.5f;
        }
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.crit((Entity)target);
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                player.getCooldowns().removeCooldown((Item)this);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.GOLD);
    }
}

