/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.entities;

import com.samsthenerd.monthofswords.registry.SwordsModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class LeafAttackEntity
extends ThrowableItemProjectile {
    public LeafAttackEntity(Level world) {
        this((EntityType<? extends LeafAttackEntity>)((EntityType)SwordsModEntities.LEAF_ATTACK.get()), world);
    }

    public LeafAttackEntity(EntityType<? extends LeafAttackEntity> type, Level world) {
        super(type, world);
    }

    protected void onHitEntity(EntityHitResult hit) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)level;
        hit.getEntity().hurt(this.damageSources().magic(), 1.0f);
        hit.getEntity().push(this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().multiply(0.5, 0.0, 0.5).add(0.0, 0.4, 0.0));
        sWorld.sendParticles((ParticleOptions)ParticleTypes.CHERRY_LEAVES, hit.getLocation().x() + this.getRandom().nextDouble(), hit.getLocation().y() + this.getRandom().nextDouble(), hit.getLocation().z() + this.getRandom().nextDouble(), 3, 0.0, 0.0, 0.0, 0.0);
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
    }

    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            sWorld.sendParticles((ParticleOptions)ParticleTypes.CHERRY_LEAVES, this.position().x() + this.getRandom().nextDouble(), this.position().y() + this.getRandom().nextDouble(), this.position().z() + this.getRandom().nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return Items.PINK_PETALS;
    }
}

