/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModLoot;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootTable;

public record Description(RegistrySupplier<? extends Item> item, List<SwordPower> powers, List<AcquisitionDesc> acqDescs, int textColor) {
    public static final Component PASSIVE_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.passivepower");
    public static final Component HIT_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.hitpower");
    public static final Component USE_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.usepower");
    public static final Component CHARGE_USE_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.chargeusepower");
    public static final Component HOLD_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.holdusepower");
    public static final Component ACTION_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.actionpower", (Object[])new Object[]{Component.keybind((String)"key.swordsmod.action")});
    public static final Component SWING_POWER = Component.translatable((String)"monthofswords.descriptionutil.powertype.swingpower");
    public static final Component INV_USE = Component.translatable((String)"monthofswords.descriptionutil.powertype.invusepower");
    public static int[] TIME_HIERARCHY = new int[]{1728000, 72000, 1200, 20};
    public static String[] TIME_HIERARCHY_LABELS = new String[]{"day", "hour", "min", "sec"};

    public List<Component> getSummaryTooltip() {
        ArrayList<Component> resTT = new ArrayList<Component>();
        resTT.addAll(this.powers.stream().map(p -> p.getPowerTitle(this)).toList());
        if (!resTT.isEmpty()) {
            resTT.add((Component)Component.literal((String)""));
            resTT.add((Component)this.applyColor((Component)Component.translatable((String)"monthofswords.tooltip.shiftpowers")).withStyle(ChatFormatting.ITALIC));
        }
        return resTT;
    }

    public List<Component> getPowerTooltip() {
        ArrayList<Component> powTTs = new ArrayList<Component>();
        for (SwordPower pow : this.powers) {
            powTTs.addAll(pow.getPowerTooltip(this));
            powTTs.add((Component)Component.literal((String)""));
        }
        return powTTs;
    }

    public List<Component> getAcquisitionTooltip() {
        ArrayList<Component> acqTTs = new ArrayList<Component>();
        for (AcquisitionDesc acqd : this.acqDescs) {
            acqTTs.addAll(acqd.getAcqTooltip().stream().map(this::applyColor).toList());
            acqTTs.add((Component)Component.literal((String)""));
        }
        return acqTTs;
    }

    public List<Component> getTooltipFull(ItemStack stack, Item.TooltipContext context, TooltipFlag type) {
        DescriptionItemComponent descData = (DescriptionItemComponent)stack.get(SwordsModComponents.ITEM_DESCRIPTION_DATA);
        if (descData == null) {
            if (Description.hasShiftSafe()) {
                return this.getPowerTooltip();
            }
            return this.getSummaryTooltip();
        }
        ArrayList<Component> tt = new ArrayList<Component>();
        if (descData.hintMode) {
            tt.addAll(this.getAcquisitionTooltip());
            tt.add((Component)this.applyColor((Component)Component.translatable((String)"monthofswords.descriptionutil.switchtopower")).withStyle(ChatFormatting.ITALIC));
        } else {
            if (Description.hasShiftSafe()) {
                tt.addAll(this.getPowerTooltip());
            } else {
                tt.addAll(this.getSummaryTooltip());
            }
            tt.add((Component)Component.literal((String)""));
            tt.add((Component)this.applyColor((Component)Component.translatable((String)"monthofswords.descriptionutil.switchtohint")).withStyle(ChatFormatting.ITALIC));
        }
        return tt;
    }

    public static Description forItem(RegistrySupplier<? extends Item> item) {
        return new Description(item, new ArrayList<SwordPower>(), new ArrayList<AcquisitionDesc>(), 0xFFFFFF);
    }

    public Description withPower(SwordPower ... power) {
        ArrayList<SwordPower> newPowers = new ArrayList<SwordPower>(this.powers);
        newPowers.addAll(Arrays.asList(power));
        return new Description(this.item, newPowers, this.acqDescs, this.textColor);
    }

    public Description withAcquisitionDesc(AcquisitionDesc ... descs) {
        ArrayList<AcquisitionDesc> newAcqs = new ArrayList<AcquisitionDesc>(this.acqDescs);
        newAcqs.addAll(Arrays.asList(descs));
        return new Description(this.item, this.powers, newAcqs, this.textColor);
    }

    public Description withLootAcqDesc() {
        return this.withAcquisitionDesc(new AcquisitionDesc.LootDropDesc(SwordsModLoot.LOOT_LISTS.get((Object)this.item.getId()).stream().toList()));
    }

    public Description withMatchingRecipe() {
        return this.withAcquisitionDesc(new AcquisitionDesc.CraftingDesc(this.item.getId()));
    }

    public Description withSpecificAcqDesc() {
        return this.withAcquisitionDesc(new AcquisitionDesc.SpecificText(this.item.getId().toLanguageKey()));
    }

    public Description withTextColor(int color) {
        return new Description(this.item, this.powers, this.acqDescs, color);
    }

    public Description withTextColor(ChatFormatting fm) {
        return new Description(this.item, this.powers, this.acqDescs, fm.isColor() ? fm.getColor() : this.textColor);
    }

    public Description finalize(Consumer<Description> consumer) {
        consumer.accept(this);
        return this;
    }

    public Description conditionally(UnaryOperator<Description> op, boolean condition) {
        return condition ? (Description)op.apply(this) : this;
    }

    public MutableComponent applyColor(Component t) {
        return t.copy().withColor(this.textColor);
    }

    public static List<Component> getContinuousText(Function<Integer, List<String>> langPatterns, Object ... args) {
        int i = 0;
        boolean keepGoing = true;
        ArrayList<Component> ts = new ArrayList<Component>();
        while (keepGoing) {
            List<String> keys = langPatterns.apply(i);
            keepGoing = false;
            for (String k : keys) {
                if (!I18n.exists((String)k)) continue;
                String str = I18n.get((String)k, (Object[])args);
                if (str.equals("/endseq/")) break;
                ts.add((Component)Component.translatable((String)k, (Object[])args));
                keepGoing = true;
                break;
            }
            ++i;
        }
        return ts;
    }

    public static Function<Integer, List<String>> makeLangPatternProvider(String base, List<String> flags) {
        return i -> {
            ArrayList<Object> keys = new ArrayList<Object>();
            for (String f : flags) {
                if (i == 0) {
                    keys.add(base + "." + f);
                }
                keys.add(base + "." + i + "." + f);
            }
            if (i == 0) {
                keys.add(base);
            }
            keys.add(base + "." + i);
            return keys;
        };
    }

    public static Component getFormattedTime(int tickCount) {
        MutableComponent timeText = Component.empty();
        boolean modified = false;
        for (int i = 0; i < 3; ++i) {
            int timeUnit = tickCount / TIME_HIERARCHY[i];
            if (timeUnit != 0) {
                timeText.append((Component)Component.translatable((String)("monthofswords.descriptionutil.timelabel." + TIME_HIERARCHY_LABELS[i]), (Object[])new Object[]{timeUnit}));
                modified = true;
            }
            tickCount %= TIME_HIERARCHY[i];
        }
        double secs = (double)tickCount / 20.0;
        if (secs != 0.0 || !modified) {
            timeText.append((Component)Component.translatable((String)"monthofswords.descriptionutil.timelabel.sec", (Object[])new Object[]{secs}));
        }
        return timeText;
    }

    public static boolean hasShiftSafe() {
        return Platform.getEnvironment() == Env.SERVER || Screen.hasShiftDown();
    }

    public record SwordPower(String name, Component powerType, Optional<Integer> cooldown) {
        public List<Component> getPowerTooltip(Description desc) {
            String powerTitleKey = ((Item)desc.item.get()).getDescriptionId() + ".power." + this.name;
            Component fullPowerTitle = this.getPowerTitle(desc);
            ArrayList<Component> powerText = new ArrayList<Component>();
            powerText.add(fullPowerTitle);
            List<Component> powerDescs = Description.getContinuousText(Description.makeLangPatternProvider(powerTitleKey + ".desc", List.of()), new Object[0]);
            this.cooldown.ifPresent(cd -> powerDescs.add((Component)Component.translatable((String)"monthofswords.descriptionutil.powercooldown", (Object[])new Object[]{Description.getFormattedTime(cd)})));
            powerText.addAll(powerDescs.stream().map(t -> Component.literal((String)" ").append(t).withStyle(ChatFormatting.ITALIC).withColor(desc.textColor)).toList());
            return powerText;
        }

        public Component getPowerTitle(Description desc) {
            String powerTitleKey = ((Item)desc.item.get()).getDescriptionId() + ".power." + this.name;
            MutableComponent powerTitle = Component.translatableWithFallback((String)powerTitleKey, (String)"");
            Object fullPowerTitle = I18n.exists((String)powerTitleKey) ? Component.translatable((String)"monthofswords.descriptionutil.powertitleformat", (Object[])new Object[]{powerTitle, this.powerType}) : this.powerType;
            return fullPowerTitle.copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE}).withColor(desc.textColor());
        }
    }

    public static interface AcquisitionDesc {
        public List<Component> getAcqTooltip();

        public record SpecificText(String baseItemKey) implements AcquisitionDesc
        {
            @Override
            public List<Component> getAcqTooltip() {
                return Description.getContinuousText(Description.makeLangPatternProvider(this.baseItemKey + ".acquisition", List.of()), new Object[0]);
            }
        }

        public record CraftingDesc(ResourceLocation recId) implements AcquisitionDesc
        {
            @Override
            public List<Component> getAcqTooltip() {
                return List.of();
            }
        }

        public record LootDropDesc(List<Tuple<ResourceKey<LootTable>, Float>> tableChances) implements AcquisitionDesc
        {
            public static Map<String, String> EMI_LOOT_TYPE_LOOKUP = new HashMap<String, String>(Map.of("chests", "chest", "spawners", "chest", "dispensers", "chest"));

            @Override
            public List<Component> getAcqTooltip() {
                ArrayList<Component> tt = new ArrayList<Component>();
                tt.add((Component)Component.translatable((String)"monthofswords.descriptionutil.acq.title.loot"));
                for (Tuple<ResourceKey<LootTable>, Float> tc : this.tableChances) {
                    MutableComponent t = Component.literal((String)" ");
                    Component tableText = LootDropDesc.getLootTableName((ResourceKey<LootTable>)((ResourceKey)tc.getA()));
                    float roundedVal = (float)Math.round(((Float)tc.getB()).floatValue() * 10000.0f) / 100.0f;
                    t.append((Component)Component.translatable((String)"monthofswords.descriptionutil.acq.loot", (Object[])new Object[]{Float.valueOf(roundedVal), tableText}));
                    tt.add((Component)t);
                }
                return tt;
            }

            public static Component getLootTableName(ResourceKey<LootTable> lootTableKey) {
                ResourceLocation lootId = lootTableKey.location();
                String sensibleKey = "loot." + lootId.getNamespace() + "." + lootId.getPath();
                if (I18n.exists((String)sensibleKey)) {
                    return Component.translatable((String)sensibleKey);
                }
                String lootType = lootId.getPath().split("/")[0];
                String lootTypeEMI = EMI_LOOT_TYPE_LOOKUP.getOrDefault(lootType, lootType);
                String emiKey = "emi_loot." + lootTypeEMI + "." + String.valueOf(lootId);
                if (I18n.exists((String)emiKey)) {
                    return Component.translatable((String)emiKey);
                }
                return Component.literal((String)lootId.toString());
            }
        }
    }

    public record DescriptionItemComponent(boolean hintMode, Optional<RecipeTooltipData> ttData) {
        public static final Codec<DescriptionItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("hintMode").forGetter(DescriptionItemComponent::hintMode), (App)RecipeTooltipData.CODEC.optionalFieldOf("ttData").forGetter(DescriptionItemComponent::ttData)).apply((Applicative)instance, DescriptionItemComponent::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DescriptionItemComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, DescriptionItemComponent::hintMode, (StreamCodec)RecipeTooltipData.PACKET_CODEC.apply(ByteBufCodecs::optional), DescriptionItemComponent::ttData, DescriptionItemComponent::new);
    }
}

