/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.render;

import com.samsthenerd.monthofswords.render.FakeGhostPlayerManager;
import com.samsthenerd.monthofswords.render.GhostifyTexture;
import com.samsthenerd.monthofswords.utils.ColorUtils;
import java.util.Optional;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public interface GhostlyProvider {
    public static Optional<GhostlyProvider> getGhostlyProvider(LivingEntity livEnt) {
        if (livEnt instanceof FakeGhostPlayerManager.GhostlyPlayerEntity) {
            return Optional.of((hd, v, t) -> (float)((double)0.47f + (double)0.1f * hd));
        }
        return Optional.empty();
    }

    public int getGhostlyColor(int var1, int var2, int var3, int var4, Vec3 var5, float var6);

    default public RenderType getGhostlyRenderLayer(RenderType originalLayer, LivingEntity entity, ResourceLocation originalTextureId, boolean showBody, boolean translucent, boolean showOutline) {
        ResourceLocation ghostlyId = GhostifyTexture.getGhostifiedTexture(originalTextureId).orElse(originalTextureId);
        return RenderType.itemEntityTranslucentCull((ResourceLocation)ghostlyId);
    }

    default public int getLightmapCoords(int u, int v, Vec3 lastVec, float time) {
        return 0xF000F0;
    }

    public static interface HueGhostlyProvider
    extends GhostlyProvider {
        public float getGhostlyHue(double var1, Vec3 var3, float var4);

        @Override
        default public int getGhostlyColor(int red, int green, int blue, int alpha, Vec3 lastVec, float time) {
            double t = Mth.positiveModulo((float)time, (float)4.0f);
            t = t < 2.0 ? t / 4.0 : 1.0 - t / 4.0;
            Vec3 d = new Vec3(1.0, 3.0, 1.0).normalize();
            double hd = Mth.positiveModulo((double)(lastVec.dot(d) - (double)time), (double)1.0);
            float hue = this.getGhostlyHue(hd, lastVec, time);
            int argb = ColorUtils.HSBtoRGB(hue, 1.0f, 1.0f);
            return FastColor.ARGB32.color((int)128, (int)argb);
        }
    }
}

