/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StealthSwordItem
extends SwordtemberItem {
    private static final ResourceLocation STEALTH_SWORD_SNEAK_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"stealthswordsneak");
    private static final ResourceLocation STEALTH_SWORD_FALL_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"stealthswordfall");
    private static final Fireworks DEFAULT_FIREWORK = new Fireworks(1, List.of(new FireworkExplosion(FireworkExplosion.Shape.SMALL_BALL, IntList.of((int)ChatFormatting.BLACK.getColor()), IntList.of((int)ChatFormatting.BLACK.getColor(), (int)ChatFormatting.DARK_RED.getColor()), false, false)));

    public StealthSwordItem(Item.Properties itemSettings) {
        super((Tier)Tiers.IRON, itemSettings.attributes(SwordItem.createAttributes((Tier)Tiers.IRON, (int)3, (float)-2.4f).withModifierAdded(Attributes.SNEAKING_SPEED, new AttributeModifier(STEALTH_SWORD_SNEAK_MODIFIER, 0.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(STEALTH_SWORD_FALL_MODIFIER, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        boolean ready = !user.getCooldowns().isOnCooldown((Item)this);
        ItemStack handStack = user.getItemInHand(hand);
        if (world instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)world;
            if (ready) {
                if (!user.isShiftKeyDown()) {
                    ItemStack rocketStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
                    rocketStack.set(DataComponents.FIREWORKS, (Object)((Fireworks)user.getItemInHand(hand).getComponents().getOrDefault(DataComponents.FIREWORKS, (Object)DEFAULT_FIREWORK)));
                    FireworkRocketEntity rocketEntity = new FireworkRocketEntity(world, rocketStack, null, user.getX(), user.getEyeY() - (double)0.15f, user.getZ(), true);
                    rocketEntity.setDeltaMovement(user.getViewVector(0.0f));
                    sWorld.addFreshEntity((Entity)rocketEntity);
                    for (Entity nearbyEnt : world.getEntities((Entity)user, new AABB(user.getEyePosition(), user.position()).inflate(user.entityInteractionRange() * 2.0))) {
                        if (nearbyEnt instanceof LivingEntity) {
                            LivingEntity liveEnt = (LivingEntity)nearbyEnt;
                            liveEnt.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100));
                        }
                        if (!(nearbyEnt instanceof Mob)) continue;
                        Mob nearbyMob = (Mob)nearbyEnt;
                        nearbyMob.addEffect(new MobEffectInstance(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.SMOKE_BOMBED), 100));
                    }
                    handStack.hurtAndBreak(2, (LivingEntity)user, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
                user.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 600));
                user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 2));
                user.addEffect(new MobEffectInstance(MobEffects.JUMP, 300, 2));
                user.getCooldowns().addCooldown((Item)this, 600);
                return InteractionResultHolder.success((Object)handStack);
            }
        }
        return ready ? InteractionResultHolder.success((Object)handStack) : InteractionResultHolder.pass((Object)handStack);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Vec3 attackerToTargetVec;
        Vec3 targetLook;
        double dotProd;
        LivingEntity liveAttacker;
        Level level;
        Entity attacker = damageSource.getEntity();
        float extraDamage = super.getAttackDamageBonus(target, baseAttackDamage, damageSource);
        if (!(attacker instanceof LivingEntity) || !((level = (liveAttacker = (LivingEntity)attacker).level()) instanceof ServerLevel)) {
            return extraDamage;
        }
        ServerLevel sWorld = (ServerLevel)level;
        boolean wasSuperSneakAttack = false;
        if (liveAttacker.hasEffect(MobEffects.INVISIBILITY)) {
            Player playerAttacker;
            if (liveAttacker instanceof Player && (playerAttacker = (Player)liveAttacker).getCooldowns().isOnCooldown((Item)this)) {
                wasSuperSneakAttack = true;
                extraDamage += 0.75f;
            }
            extraDamage += 0.5f;
            liveAttacker.removeEffect(MobEffects.INVISIBILITY);
        }
        if ((dotProd = (targetLook = target.getViewVector(0.0f).multiply(1.0, 1.0, 0.0).normalize()).dot(attackerToTargetVec = target.position().subtract(attacker.position()).normalize())) > 0.0) {
            extraDamage += 1.0f;
            if (wasSuperSneakAttack && target instanceof LivingEntity) {
                LivingEntity liveTarget = (LivingEntity)target;
                liveTarget.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100));
            }
        }
        if (attacker.isShiftKeyDown()) {
            extraDamage += 0.25f;
        }
        return extraDamage;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (otherStack.getItem().equals(Items.FIREWORK_ROCKET)) {
            stack.set(DataComponents.FIREWORKS, (Object)((Fireworks)otherStack.get(DataComponents.FIREWORKS)));
            otherStack.shrink(1);
            return true;
        }
        return false;
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.DARK_RED);
    }
}

