package com.samsthenerd.monthofswords.tooltips;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.mixins.MixinSmithingTransformRecipeAccessor;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

public record RecipeTooltipComponent(RecipeTooltipData data) implements ClientTooltipComponent {
    @Override
    public int getHeight() {
        return 83;
    }

    @Override
    public int getWidth(Font textRenderer) {
        return 150;
    }

    public static final ResourceLocation CRAFTING_BACKGROUND = SwordsMod.id("textures/gui/crafting_background.png");
    public static final ResourceLocation SMITHING_BACKGROUND = SwordsMod.id("textures/gui/smithing_background.png");

    @Override
    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        if(data.rec() instanceof CraftingRecipe craftRec){
            context.blit(CRAFTING_BACKGROUND, x, y, 100, 0, 0, 146, 83, 256, 256);
            var ingrs = craftRec.getIngredients();

            int recWidth = 3;
            int recXOffset = 0;
            if(craftRec instanceof ShapedRecipe shapedRec){
                recWidth = Math.min(shapedRec.getWidth(), 3); // idk about nonsense
                if(recWidth == 1) recXOffset = 1;
            }

            for(int i = 0; i < ingrs.size(); i++){
                int ingrX = 18 + ((i % recWidth)+recXOffset) * 18;
                int ingrY = 15 + (i / recWidth) * 18;
                ItemStack ingrStack = Arrays.stream(ingrs.get(i).getItems()).findFirst().orElse(ItemStack.EMPTY);
                context.renderItem(ingrStack, x+ingrX, y+ingrY);
            }

            context.renderItem(craftRec.getResultItem(Minecraft.getInstance().level.registryAccess()), 112+x, 33+y);

        } else if (data.rec() instanceof SmithingTransformRecipe smithRec
            && smithRec instanceof MixinSmithingTransformRecipeAccessor smithRecAcc){

            context.blit(SMITHING_BACKGROUND, x, y, 100, 0, 0, 146, 83, 256, 256);
            List<Ingredient> ingrs = List.of(smithRecAcc.getTemplateIngredient(), smithRecAcc.getBaseIngredient(), smithRecAcc.getAdditionIngredient());
            for(int i = 0; i < ingrs.size(); i++){
                int ingrX = 20 + i * 18;
                int ingrY = 43 - i;
                ItemStack ingrStack = Arrays.stream(ingrs.get(i).getItems()).findFirst().orElse(ItemStack.EMPTY);
                context.renderItem(ingrStack, x+ingrX, y+ingrY);
            }

            context.renderItem(smithRec.getResultItem(Minecraft.getInstance().level.registryAccess()), 110+x, 43+y);
        }
    }
}
