package com.samsthenerd.monthofswords.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.monthofswords.items.WovenSwordItem;
import com.samsthenerd.monthofswords.registry.SwordsModAttributes;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.registry.SwordsModStatusEffects.FriendOfEntityStatusEffect;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/*
 * this is yoinked hard from artifact's cloud in a bottle:
 * https://github.com/florensie/artifacts-fabric/blob/3a4e29d152172a5424a84b11ee2b9755c4be6c56/src/main/java/artifacts/mixin/item/cloudinabottle/LivingEntityMixin.java
 * via gloop. so has some artifacts from that maybe
 */
@Mixin(LivingEntity.class)
public abstract class MixinLivEntJump extends Entity implements LivingEntDuck {
    @Shadow
    protected boolean jumping;
    // Is entity double jumping in this tick
//    @Unique
//    private boolean isDoubleJumping = false;
    // Has entity released jump key since last jump
    @Unique
    private boolean jumpWasReleased = false;
//    // Has entity double jumped during current airtime
//    @Unique
//    private boolean hasDoubleJumped = false;

    @Unique
    private long startedWovenDash = -1;

    @Shadow
    public abstract boolean isClimbing();

    @Inject(method="tickMovement()V", at=@At("HEAD"))
    public void checkForHittingTheGround(CallbackInfo info){
        LivingEntity self = (LivingEntity) (Object) this;
        jumpWasReleased |= !this.jumping;

//
//        boolean flying = self instanceof PlayerEntity player && player.getAbilities().flying;
//        if (this.jumping && this.jumpWasReleased && !this.hasVehicle() && !flying
//            && lastHitGroundAfterDash != -1 && self.getWorld().getTime() - lastHitGroundAfterDash <= 5) {
//            SwordsMod.LOGGER.info("maybe jump?");
////            this.hasDoubleJumped = true;
//        }

        long dashLength = startedWovenDash == -1 ? -1 : self.level().getGameTime() - startedWovenDash;

        // if we hit the ground reset our thing and track when that happened
        if ((this.onGround() || this.isClimbing()) && !this.isInWater()) {
            if(dashLength > 10 && self instanceof ServerPlayer user){
                startedWovenDash = -1;
                user.getCooldowns().addCooldown(SwordsModItems.WOVEN_SWORD.get(), 0);
            }
        }

        // do some sparkles :p
        if(self instanceof ServerPlayer user){
            if(dashLength >= 0){
                WovenSwordItem.makeTransParticles(user);
            }
        }
    }

    @Inject(method = "jump", at = @At("RETURN"))
    private void setJumpReleased(CallbackInfo info) {
        this.jumpWasReleased = false;
    }

//    @Inject(method = "setJumping", at = @At("HEAD"))
//    private void hookListenToSetJumping(boolean jumpingInput, CallbackInfo ci) {
//        if(jumpingInput && !jumping) SwordsMod.LOGGER.info("setJumping");
////        this.jumpWasReleased = false;
//    }

    // garbage to shut the compiler up
    public MixinLivEntJump(EntityType<?> type, Level world){
        super(type, world);
    }

    @Override
    public boolean isDashingTransgenderly(){
        return startedWovenDash != -1;
    }

    @Override
    public void makeDashTransgenderly(){
        LivingEntity self = (LivingEntity) (Object) this;
        startedWovenDash = self.level().getGameTime();
    }

    @Unique
    private long mos$lastEchoUsage = -1;

    @Override
    public void setLastEchoUsage(long t) {

        Entity entThis = (Entity) this;
        Vec3 originalVelocity = entThis.getDeltaMovement();
        // only cancel velocity at start
        boolean onGround = entThis.onGround();
        if(!onGround && entThis.isDescending()){
            entThis.setDeltaMovement(0, 0, 0);
        }
        mos$lastEchoUsage = t;
    }

    @Override
    public long getLastEchoUsage() {
        return mos$lastEchoUsage;
    }


    @Inject(
        method="tick",
        at=@At("HEAD")
    )
    public void mos$checkEchoUsageInTick(CallbackInfo ci){
        if(mos$lastEchoUsage != -1 && ((LivingEntity)(Object)this).tickCount - mos$lastEchoUsage > 5){
            mos$lastEchoUsage = -1;
        }
    }

//    @ModifyReturnValue(
//        method="getVelocityMultiplier",
//        at=@At("RETURN")
//    )
//    public float mos$noVelocityWhenEchoing(float original){
//        if(mos$lastEchoUsage != -1){
//            return 0;
//        } else {
//            return original;
//        }
//    }


    @ModifyReturnValue(
        method="getGravity", at=@At("RETURN")
    )
    public double mos$slowFallWhileEchoSword(double originalGravity){
        Entity entThis = (Entity) this;
        if(mos$lastEchoUsage != -1 && entThis.getDeltaMovement().y <= 0
            && entThis.isDescending() && !entThis.onGround()){
            return originalGravity * 0;
        }
        return originalGravity;
    }

    @ModifyReturnValue(
        method="Lnet/minecraft/entity/LivingEntity;canTarget(Lnet/minecraft/entity/LivingEntity;)Z",
        at = @At("RETURN")
    )
    public boolean monthOfSwords$becomeUntargetable(boolean original, LivingEntity target){
        if(original){
            for(MobEffectInstance effInst : target.getActiveEffects()){
                if(effInst.getEffect().value() instanceof FriendOfEntityStatusEffect friendEff
                && friendEff.friendPredicate.test(this)){
                    return false;
                }
            }

        }
        return original;
    }

    @ModifyReturnValue(
        method="createLivingAttributes", at=@At("RETURN")
    )
    private static AttributeSupplier.Builder monthOfSwords$addDefaultLivingAttributes(AttributeSupplier.Builder builder){
        SwordsModAttributes.init();
        return builder.add(SwordsModAttributes.ENDERMAN_FRIENDLY, 0);
    }

//    @Inject(
//        method="teleport",
//        at=@At("HEAD"), cancellable = true
//    )
//    public void monthOfSwords$cancelLivEntTeleport(double x, double y, double z, boolean particleEffects, CallbackInfoReturnable<Boolean> cir){
//        LivingEntity livEntThis = (LivingEntity)(Object)this;
//        if(livEntThis.hasStatusEffect(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.DISPLACED))){
//            cir.setReturnValue(false);
//        }
//    }

}
