package com.samsthenerd.monthofswords.items;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;

// this is really just for sun and moon mod so it won't be too too extendable.
public class TimeBasedSwordItem extends SwordtemberItem{

    public static final Function<Item, ClassyToolMaterial> MAT_SUPPLIER = (repairItem) -> new ClassyToolMaterial(750, 8f, 2f,
            BlockTags.INCORRECT_FOR_IRON_TOOL, 18, () -> Ingredient.of(repairItem));

    private final boolean dayOrNight;

    public TimeBasedSwordItem(Item repairItem, Item.Properties settings, boolean dayOrNight){
        super(MAT_SUPPLIER.apply(repairItem), settings.attributes(SwordItem.createAttributes(MAT_SUPPLIER.apply(repairItem), 3, -2.4f)));
        this.dayOrNight = dayOrNight;
    }

    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        if(dayOrNight){
            return target.level().isDay() ? 1.5f : 0;
        } else {
            return target.level().isNight() ? 1.5f : 0;
        }
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(dayOrNight ? ChatFormatting.YELLOW : ChatFormatting.BLUE);
    }
}
