package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.screen.SwordCalendarScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CalendarItem extends Item {
    public CalendarItem(Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if(world.isClientSide()){
            Minecraft.getInstance().setScreen(new SwordCalendarScreen());
        }
        return InteractionResultHolder.sidedSuccess(user.getItemInHand(hand), true);
    }
}
