package com.samsthenerd.monthofswords.entities;

import com.samsthenerd.monthofswords.registry.SwordsModEntities;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class LeafAttackEntity extends ThrowableItemProjectile{

    public LeafAttackEntity(Level world) {
        this(SwordsModEntities.LEAF_ATTACK.get(), world);
    }

    public LeafAttackEntity(EntityType<? extends LeafAttackEntity> type, Level world) {
        super(type, world);
    }

    protected void onHitEntity(EntityHitResult hit) {
        if(!(level() instanceof ServerLevel sWorld)) return;
        hit.getEntity().hurt(damageSources().magic(), 1);
        hit.getEntity().push(
            this.getDeltaMovement().multiply(1,0,1).normalize()
                .multiply(0.5, 0, 0.5).add(0,0.4,0));

        sWorld.sendParticles(ParticleTypes.CHERRY_LEAVES,
            hit.getLocation().x() + getRandom().nextDouble(),
            hit.getLocation().y() + getRandom().nextDouble(),
            hit.getLocation().z() + getRandom().nextDouble(),
            3,
            0, 0, 0, 0);
    }

    @Override
    protected void onHitBlock(BlockHitResult hit) {
//        if(getWorld() instanceof ServerWorld sWorld && hit.getType() == Type.BLOCK){
//            if(getRandom().nextFloat() < 0.1){
//                var petalEnt = new ItemEntity(sWorld, hit.getPos().getX(), hit.getPos().getY(), hit.getPos().getZ(),
//                    new ItemStack(SwordsModItems.FOREST_PETALS.get()));
//                sWorld.spawnEntity(petalEnt);
//            }
//        }
        super.onHitBlock(hit);
    }

    @Override
    public void tick() {
        if(level() instanceof ServerLevel sWorld){
            sWorld.sendParticles(ParticleTypes.CHERRY_LEAVES,
                position().x() + getRandom().nextDouble(),
                position().y() + getRandom().nextDouble(),
                position().z() + getRandom().nextDouble(),
                1,
                0, 0, 0, 0);
        }
        super.tick();
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    @Override
    protected Item getDefaultItem() {
        return Items.PINK_PETALS;
    }
}
