package com.samsthenerd.monthofswords.xplat;

import com.mojang.serialization.Codec;
import java.util.function.BiPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;

public interface CAttachmentType<T>{

    interface Builder<T>{
        Builder<T> persistent(Codec<T> codec, boolean copyOnDeath);

        Builder<T> clientSyncable(StreamCodec<? super RegistryFriendlyByteBuf, T> packetCodec, BiPredicate<CAttachmentTarget, ServerPlayer> syncPredicate);
    }
}
