package com.samsthenerd.monthofswords.registry;

import com.mojang.serialization.Codec;
import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.CrystalSwordItem.ResonatingComponent;
import com.samsthenerd.monthofswords.items.SummonableSwordItem.SummonSwordComponentData;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;

public class SwordsModComponents {
    private static DeferredRegister<DataComponentType<?>> COMPONENT_TYPES = DeferredRegister.create(SwordsMod.MOD_ID, Registries.DATA_COMPONENT_TYPE);

    public static DataComponentType<Integer> POTION_HITS = component("potionhits", builder -> builder.persistent(Codec.INT).networkSynchronized(ByteBufCodecs.INT));

    public static DataComponentType<SummonSwordComponentData> SUMMON_SWORD_DATA = component("summon_sword_data", builder ->
        builder.persistent(SummonSwordComponentData.CODEC).networkSynchronized(SummonSwordComponentData.PACKET_CODEC));

    public static DataComponentType<ResonatingComponent> RESONANCE_DATA = component("crystal_resonance_data", builder ->
        builder.persistent(ResonatingComponent.CODEC).networkSynchronized(ResonatingComponent.PACKET_CODEC));

    private static <T> DataComponentType<T> component(String id, UnaryOperator<DataComponentType.Builder<T>> builderOperator){
        DataComponentType<T> comp = builderOperator.apply(DataComponentType.builder()).build();
        COMPONENT_TYPES.register(SwordsMod.id(id), () -> comp);
        return comp;
    }

    public static void register(){
        COMPONENT_TYPES.register();
    }
}
