/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.render;

import com.mojang.authlib.GameProfile;
import com.samsthenerd.monthofswords.mixins.MixinLivingEntAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;

public class FakeGhostPlayerManager {
    private static final Map<GameProfile, GhostlyPlayerEntity> GHOST_PLAYERS = new HashMap<GameProfile, GhostlyPlayerEntity>();

    public static void makeFakePlayer(GameProfile profile, Player player) {
        ClientLevel cWorld = Minecraft.getInstance().level;
        GhostlyPlayerEntity ghost = new GhostlyPlayerEntity(cWorld, Minecraft.getInstance().getGameProfile(), player);
        ghost.setUUID(UUID.randomUUID());
        ghost.noPhysics = true;
        cWorld.addEntity((Entity)ghost);
        GHOST_PLAYERS.put(profile, ghost);
    }

    public static void removePlayer(GameProfile profile) {
        GhostlyPlayerEntity ghost = GHOST_PLAYERS.get(profile);
        if (ghost == null) {
            return;
        }
        ghost.discard();
        GHOST_PLAYERS.remove(profile);
    }

    public static Optional<GhostlyPlayerEntity> getGhostPlayer(GameProfile profile) {
        return Optional.ofNullable(GHOST_PLAYERS.get(profile));
    }

    public static void setPlayerPosition(GameProfile profile, Vec3 pos) {
        FakeGhostPlayerManager.getGhostPlayer(profile).ifPresent(ghost -> ghost.setPos(pos));
    }

    public static void makeFakePlayer() {
        FakeGhostPlayerManager.makeFakePlayer(Minecraft.getInstance().getGameProfile(), (Player)Minecraft.getInstance().player);
    }

    public static void removePlayer() {
        FakeGhostPlayerManager.removePlayer(Minecraft.getInstance().getGameProfile());
    }

    public static Optional<GhostlyPlayerEntity> getGhostPlayer() {
        return FakeGhostPlayerManager.getGhostPlayer(Minecraft.getInstance().getGameProfile());
    }

    public static void setPlayerPosition(Vec3 pos) {
        FakeGhostPlayerManager.setPlayerPosition(Minecraft.getInstance().getGameProfile(), pos);
    }

    public static class GhostlyPlayerEntity
    extends RemotePlayer {
        public Player playerBody;

        public GhostlyPlayerEntity(ClientLevel clientWorld, GameProfile gameProfile, Player playerBody) {
            super(clientWorld, gameProfile);
            this.playerBody = playerBody;
        }

        public boolean canCollideWith(Entity other) {
            return false;
        }

        public PlayerSkin getSkin() {
            return Minecraft.getInstance().getSkinManager().getInsecureSkin(this.getGameProfile());
        }

        public boolean isModelPartShown(PlayerModelPart modelPart) {
            return modelPart != PlayerModelPart.CAPE;
        }

        public boolean shouldShowName() {
            return false;
        }

        public boolean isCurrentlyGlowing() {
            return !this.playerBody.hasLineOfSight((Entity)this);
        }

        public void tick() {
            if (this.playerBody.getLastEchoUsage() == -1L) {
                this.discard();
                FakeGhostPlayerManager.removePlayer(this.getGameProfile());
                return;
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, this.getX() + this.getRandom().nextDouble() - 0.5, this.getY() + this.getRandom().nextDouble(), this.getZ() + this.getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
            super.tick();
            if (this.isVisuallySwimming()) {
                ((MixinLivingEntAccessor)((Object)this)).mos$setLeaningPitch(1.0f);
                ((MixinLivingEntAccessor)((Object)this)).mos$setLastLeaningPitch(1.0f);
            } else {
                ((MixinLivingEntAccessor)((Object)this)).mos$setLeaningPitch(0.0f);
                ((MixinLivingEntAccessor)((Object)this)).mos$setLastLeaningPitch(0.0f);
            }
        }

        public void updatePlayerPose() {
            if (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
                Pose entityPose;
                Pose pose = this.isFallFlying() ? Pose.FALL_FLYING : (this.isSleeping() ? Pose.SLEEPING : (this.isSwimming() ? Pose.SWIMMING : (this.isAutoSpinAttack() ? Pose.SPIN_ATTACK : (entityPose = this.isShiftKeyDown() && !this.getAbilities().flying ? Pose.CROUCHING : Pose.STANDING))));
                Pose entityPose2 = this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(entityPose) ? entityPose : (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING);
                this.setPose(entityPose2);
            }
            if (this.canPlayerFitWithinBlocksAndEntitiesWhen(this.playerBody.getPose())) {
                this.setPose(this.playerBody.getPose());
            }
        }

        public boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose pose) {
            return super.canPlayerFitWithinBlocksAndEntitiesWhen(pose);
        }

        protected void pushEntities() {
        }

        public void moveTowardsClosestSpace(double x, double y, double z) {
            super.moveTowardsClosestSpace(x, y, z);
        }
    }
}

