package com.samsthenerd.monthofswords.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.event.events.common.LootEvent;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;

public class SwordsModLoot {

    public static void init() {
        addLoot(SwordsModItems.CURSED_SWORD, 0.2f, BuiltInLootTables.BASTION_TREASURE);
        addLoot(SwordsModItems.MOON_SWORD, 0.25f, BuiltInLootTables.JUNGLE_TEMPLE);
        addLoot(SwordsModItems.SUN_SWORD, 0.2f, BuiltInLootTables.DESERT_PYRAMID);
        addLoot(SwordsModItems.OCEAN_SWORD, 0.3f, BuiltInLootTables.SHIPWRECK_TREASURE);
        addLoot(SwordsModItems.POISON_DAGGER, 0.35f, BuiltInLootTables.SIMPLE_DUNGEON, BuiltInLootTables.PILLAGER_OUTPOST);
        addLoot(SwordsModItems.PORTAL_SWORD, 0.2f, BuiltInLootTables.NETHER_BRIDGE);
        addLoot(SwordsModItems.PORTAL_SWORD, 0.02f, BuiltInLootTables.RUINED_PORTAL);
        addLoot(SwordsModItems.LUCKY_SWORD, 0.05f, BuiltInLootTables.BASTION_BRIDGE);
        addLoot(SwordsModItems.JEWELED_SWORD, 0.01f, BuiltInLootTables.PILLAGER_OUTPOST);
        addLoot(SwordsModItems.JEWELED_SWORD, 0.5f, BuiltInLootTables.WOODLAND_MANSION);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.2f, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_RARE);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.1f, BuiltInLootTables.TRIAL_CHAMBERS_REWARD);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.2f, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS);
        addLoot(SwordsModItems.SHOCK_SWORD, 0.3f, BuiltInLootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE);
        addLoot(SwordsModItems.SILVERFISH_SHELL, 0.05f, BuiltInLootTables.STRONGHOLD_CORRIDOR);

        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            for(LootEvent.ModifyLootTable modifier : LOOT_MODIFIERS.get(key.location())){
                modifier.modifyLootTable(key, context, builtin);
            }
        });
    }

    private static final Multimap<ResourceLocation, LootEvent.ModifyLootTable> LOOT_MODIFIERS = MultimapBuilder.hashKeys().linkedHashSetValues().build();

    @SafeVarargs
    private static void addLoot(Supplier<? extends Item> itemSupplier, float chance, ResourceKey<LootTable>... tables){
        for(ResourceKey<LootTable> table : tables){
            LOOT_MODIFIERS.put(table.location(), (key, context, builtin) -> {
                LootPool.Builder pool = LootPool.lootPool().add(
                    LootItem.lootTableItem(itemSupplier.get())
                        .when(LootItemRandomChanceCondition.randomChance(chance))
                );
                context.addPool(pool);
            });
        }
    }

}
