package com.samsthenerd.monthofswords.items;

import net.minecraft.core.BlockPos;
import net.minecraft.entity.*;
import net.minecraft.item.*;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.HitResult.Type;
import java.util.function.UnaryOperator;

public class ShockSwordItem extends SwordtemberItem {
    public static final Tier COPPER_SHOCK_MATERIAL = new ClassyToolMaterial(300, 5f, 1.5f,
        BlockTags.INCORRECT_FOR_IRON_TOOL, 18, () -> Ingredient.of(Items.COPPER_INGOT));

    public ShockSwordItem(Item.Properties itemSettings) {
        super(COPPER_SHOCK_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(COPPER_SHOCK_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if((world instanceof ServerLevel sWorld && !user.getCooldowns().isOnCooldown(this))) {
            var hit = user.pick(48, 0, true);
            if(hit.getType() != Type.MISS){
                LightningBolt lightning = EntityType.LIGHTNING_BOLT.spawn(sWorld,
                    new BlockPos((int)hit.getLocation().x, (int)hit.getLocation().y, (int)hit.getLocation().z), MobSpawnType.TRIGGERED);
                if(user instanceof ServerPlayer sPlayer){
                    lightning.setCause(sPlayer);
                }
                user.getCooldowns().addCooldown(this, 20*15);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        return target.level().isThundering() ? 2f : 0;
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        attacker.level().playSound(null, target.blockPosition(), SoundEvents.TRIDENT_THUNDER.value(),
            SoundSource.PLAYERS, 10f, attacker.getRandom().nextFloat() * 0.4f + 0.8f);
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0xFC9982);
    }
}

