package com.samsthenerd.monthofswords.items;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GlowSwordItem extends SwordtemberItem implements SwordActionHaverServer{

    public GlowSwordItem(Item.Properties itemSettings) {
        super(Tiers.DIAMOND, itemSettings.attributes(
            SwordItem.createAttributes(Tiers.DIAMOND, 2, -2f))
        );
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return (style) -> style.withColor(0xAFFAE2);
    }

    // glow and do damage
    @Override
    public boolean doSwordAction(Player player, ItemStack stack) {
        if(!player.getCooldowns().isOnCooldown(this)){
            var nearEnts = player.level().getEntities(player, AABB.ofSize(player.position(), 32, 32, 16));
            for(var ent : nearEnts){
                if(ent instanceof LivingEntity livEnt){
                    livEnt.addEffect(new MobEffectInstance(MobEffects.GLOWING, 20 * 60));
                    ent.hurt(player.damageSources().magic(), 5);
                }
            }
            player.getCooldowns().addCooldown(this, 20 * 45);
            stack.hurtAndBreak(5, player, player.getMainHandItem() == stack ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        return true;
    }

    //
    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        return target.isCurrentlyGlowing() ? 2f : 0;
    }

    // glow for 45 seconds on hit
    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 20 * 45));
        return super.hurtEnemy(stack, target, attacker);
    }

    // give all nearby glowing for a minute
    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if(!player.getCooldowns().isOnCooldown(this) && !world.isClientSide()){
            var nearEnts = world.getEntities(player, AABB.ofSize(player.position(), 8, 8, 8));
            for(var ent : nearEnts){
                if(ent instanceof LivingEntity livEnt) livEnt.addEffect(new MobEffectInstance(MobEffects.GLOWING, 20 * 60));
            }
            player.getCooldowns().addCooldown(this, 20 * 15);
            stack.hurtAndBreak(3, player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        return InteractionResultHolder.pass(stack);
    }
}
