/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.lucky;

import com.mojang.brigadier.CommandDispatcher;
import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.lucky.LuckyFunction;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public interface DataLuckyFunction
extends LuckyFunction {
    @Override
    default public int attack(LivingEntity target, LivingEntity attacker) {
        MinecraftServer server = attacker.getServer();
        if (server == null) {
            return 0;
        }
        ServerFunctionManager funMan = server.getFunctions();
        CommandSourceStack source = attacker.createCommandSourceStack().withSuppressedOutput().withPermission(2);
        CommandFunction<CommandSourceStack> command = this.getCommand(funMan);
        if (command == null) {
            return 0;
        }
        CompoundTag macroSubst = new CompoundTag();
        macroSubst.putString("lucky_target", target.getUUID().toString());
        macroSubst.putString("lucky_attacker", attacker.getUUID().toString());
        try {
            InstantiatedFunction procedure = command.instantiate(macroSubst, funMan.getDispatcher());
            Commands.executeCommandInContext((CommandSourceStack)source, context -> ExecutionContext.queueInitialFunctionCall((ExecutionContext)context, (InstantiatedFunction)procedure, (ExecutionCommandSource)source, (CommandResultCallback)CommandResultCallback.EMPTY));
        }
        catch (FunctionInstantiationException e) {
            SwordsMod.LOGGER.error("Lucky Function Macro Error: " + String.valueOf((Object)e));
            return 0;
        }
        return this.getItemDamage();
    }

    public int getItemDamage();

    @Nullable
    public CommandFunction<CommandSourceStack> getCommand(ServerFunctionManager var1);

    @Override
    default public boolean fromDataDriven() {
        return true;
    }

    public record DataCommandLuckyFunction(String command, ResourceLocation id, int rarityWeight, LuckyFunction.LuckyModifier modifier, Integer itemDamage) implements DataLuckyFunction
    {
        @Override
        public int getWeight(double luck) {
            return this.modifier().modify(this.rarityWeight(), luck);
        }

        @Override
        @Nullable
        public CommandFunction<CommandSourceStack> getCommand(ServerFunctionManager funMan) {
            ResourceLocation madeUpID = this.id.withPath(p -> p + "_internal_synthesized_lucky_inline_function" + String.valueOf(UUID.randomUUID()));
            return CommandFunction.fromLines((ResourceLocation)madeUpID, (CommandDispatcher)funMan.getDispatcher(), (ExecutionCommandSource)funMan.getGameLoopSender(), List.of(this.command()));
        }

        @Override
        public int getItemDamage() {
            return this.itemDamage();
        }
    }

    public record DataIdLuckyFunction(ResourceLocation functionId, int rarityWeight, LuckyFunction.LuckyModifier modifier, Integer itemDamage) implements DataLuckyFunction
    {
        @Override
        public int getWeight(double luck) {
            return this.modifier().modify(this.rarityWeight(), luck);
        }

        @Override
        @Nullable
        public CommandFunction<CommandSourceStack> getCommand(ServerFunctionManager funMan) {
            return funMan.get(this.functionId()).orElse(null);
        }

        @Override
        public int getItemDamage() {
            return this.itemDamage();
        }
    }
}

