package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordLeftClickHaverServer;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SwordsModNetworking {
    public static void commonInit(){
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, SwordActionPayload.ID, SwordActionPayload.CODEC,
                (payload, context) -> {
                    Player player = context.getPlayer();
                    if(player == null) return;
                    for(ItemStack handItem : player.getHandSlots()){
                        if(handItem.getItem() instanceof SwordActionHaverServer serverActionHaver){
                            if(serverActionHaver.doSwordAction(player, handItem)){
                                break;
                            }
                        }
                    }
                });

        NetworkManager.registerReceiver(NetworkManager.Side.C2S, SwordLeftClickPayload.ID, SwordLeftClickPayload.CODEC,
            (payload, context) -> {
                Player player = context.getPlayer();
                if(player == null) return;
                ItemStack itemStack = player.getItemInHand(payload.mainHand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                if(itemStack.getItem() instanceof SwordLeftClickHaverServer serverActionHaver){
                    serverActionHaver.doSwordLCAction(player, itemStack);
                }
            });
    }

    // no way this is the proper way to do this. Absolute brain rot if so
    public record SwordActionPayload() implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<SwordActionPayload> ID = new CustomPacketPayload.Type<>(ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, "sword_action_payload"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SwordActionPayload> CODEC = StreamCodec.unit(new SwordActionPayload());

        @Override
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    // why on earth isn't this just like,, a serverside event anyways??
    public record SwordLeftClickPayload(boolean mainHand) implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<SwordLeftClickPayload> ID = new CustomPacketPayload.Type<>(ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, "sword_leftclick_payload"));
        public static final StreamCodec<ByteBuf, SwordLeftClickPayload> CODEC = ByteBufCodecs.BOOL.map(SwordLeftClickPayload::new, SwordLeftClickPayload::mainHand);

        @Override
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}
