package com.samsthenerd.monthofswords.items;

import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;

public class WingSwordItem extends SwordtemberItem {
    public static final ClassyToolMaterial WING_MATERIAL = new ClassyToolMaterial(2031, 12f, 0.1f,
            BlockTags.INCORRECT_FOR_GOLD_TOOL, 22, () -> Ingredient.EMPTY);

    public WingSwordItem(Item.Properties itemSettings){
        super(WING_MATERIAL, itemSettings.attributes(SwordItem.createAttributes(WING_MATERIAL, -1, 0)));
    }

    @Override
    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        // nop, don't take durability.
        // do knockback though.
        target.knockback(1,
                Mth.sin(attacker.getYRot() * ((float)Math.PI / 180)), -Mth.cos(attacker.getYRot() * ((float)Math.PI / 180)));
    }
}
