package com.samsthenerd.monthofswords.items;

import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments.Mutable;
import net.minecraft.world.level.Level;

public class JeweledSwordItem extends SwordtemberItem {

    public JeweledSwordItem(Item.Properties itemSettings) {
        super(Tiers.GOLD, itemSettings.attributes(
            SwordItem.createAttributes(Tiers.GOLD, 3, -2.4f))
        );
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return (style) -> style.withColor(ChatFormatting.GOLD);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if(!world.isClientSide()){
            // is this inefficient? probably! i don't know a better way to do it though!!
            var lootEnchantMaybe = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.LOOTING);
            lootEnchantMaybe.ifPresent(le ->
                stack.update(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY, enchComp -> {
                    var builder = new ItemEnchantments.Mutable(enchComp);
                    builder.upgrade(le, 5);
                    return builder.toImmutable();
                })
            );
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }
}
