package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.registry.SwordsModAttributes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class EyeSwordItem extends SwordtemberItem {
    public static final ClassyToolMaterial ENDER_MATERIAL = new ClassyToolMaterial(2000, 6f, 3f,
        BlockTags.INCORRECT_FOR_IRON_TOOL, 9, () -> Ingredient.of(Items.ENDER_EYE));

    public static ResourceLocation ENDERMAN_FRIENDLY_MOD = SwordsMod.id("enderman_eyesword_friendly");

    public static TagKey<EntityType<?>> ENDER_ENTITY = TagKey.create(Registries.ENTITY_TYPE, SwordsMod.id("ender"));

    public EyeSwordItem(Item.Properties itemSettings) {
        super(ENDER_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(ENDER_MATERIAL, 3, -2.4f)
                .withModifierAdded(
                    SwordsModAttributes.ENDERMAN_FRIENDLY,
                    new AttributeModifier(ENDERMAN_FRIENDLY_MOD, 1, AttributeModifier.Operation.ADD_VALUE),
                    EquipmentSlotGroup.MAINHAND
                )
        ));
    }

    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        float bonus = super.getAttackDamageBonus(target, baseAttackDamage, damageSource);
        if(target.level().dimension().equals(Level.END)) bonus += 0.5f;
        if(target.getType().is(ENDER_ENTITY)) bonus += 1f;
        return bonus;
    }
}
