package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.registry.SwordsModDamageTypes;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;

public class CursedSwordItem extends SwordtemberItem {

    public CursedSwordItem(Item.Properties itemSettings){
        super(Tiers.NETHERITE, itemSettings.attributes(SwordItem.createAttributes(Tiers.NETHERITE, 3, -2.9f)));
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        float targetHealthPortion = target.getMaxHealth() * 0.05f;
        float attackerHealthPortion = attacker.getMaxHealth() * 0.05f;
        target.hurt(SwordsModDamageTypes.getCurseDamage(attacker), Math.max(attackerHealthPortion, targetHealthPortion));
        attacker.hurt(SwordsModDamageTypes.getCurseDamage(attacker.level()), attackerHealthPortion);
        super.postHurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(ChatFormatting.RED);
    }
}
