/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordLeftClickHaverServer;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SwordsModNetworking {
    public static void commonInit() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SwordActionPayload.ID, SwordActionPayload.CODEC, (payload, context) -> {
            SwordActionHaverServer serverActionHaver;
            ItemStack handItem;
            Item patt0$temp;
            Player player = context.getPlayer();
            if (player == null) {
                return;
            }
            Iterator iterator = player.getHandSlots().iterator();
            while (!(!iterator.hasNext() || (patt0$temp = (handItem = (ItemStack)iterator.next()).getItem()) instanceof SwordActionHaverServer && (serverActionHaver = (SwordActionHaverServer)patt0$temp).doSwordAction(player, handItem))) {
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SwordLeftClickPayload.ID, SwordLeftClickPayload.CODEC, (payload, context) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack itemStack = player.getItemInHand(payload.mainHand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof SwordLeftClickHaverServer) {
                SwordLeftClickHaverServer serverActionHaver = (SwordLeftClickHaverServer)patt0$temp;
                serverActionHaver.doSwordLCAction(player, itemStack);
            }
        });
    }

    public record SwordActionPayload() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SwordActionPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"sword_action_payload"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SwordActionPayload> CODEC = StreamCodec.unit((Object)new SwordActionPayload());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record SwordLeftClickPayload(boolean mainHand) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SwordLeftClickPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"monthofswords", (String)"sword_leftclick_payload"));
        public static final StreamCodec<ByteBuf, SwordLeftClickPayload> CODEC = ByteBufCodecs.BOOL.map(SwordLeftClickPayload::new, SwordLeftClickPayload::mainHand);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

