/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class SwordtemberItem
extends SwordItem {
    public SwordtemberItem(Tier toolMats, Item.Properties itemSettings) {
        super(toolMats, itemSettings);
    }

    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.GRAY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (SwordtemberItem.hasShiftSafe()) {
            MutableComponent infoText = Component.translatable((String)(stack.getDescriptionId() + ".tooltip"), (Object[])new Object[]{Component.keybind((String)"key.swordsmod.action")});
            infoText.setStyle((Style)this.getSwordTooltipStyleModifier().apply(Style.EMPTY.withItalic(Boolean.valueOf(true))));
            tooltip.add((Component)infoText);
        } else {
            MutableComponent shiftMsg = Component.translatable((String)"monthofswords.tooltip.shiftmsg");
            shiftMsg.setStyle((Style)this.getSwordTooltipStyleModifier().apply(Style.EMPTY.withItalic(Boolean.valueOf(true))));
            tooltip.add((Component)shiftMsg);
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public static boolean hasShiftSafe() {
        return Platform.getEnvironment() == Env.SERVER || Screen.hasShiftDown();
    }
}

