package com.samsthenerd.monthofswords.registry;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.entities.LeafAttackEntity;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class SwordsModEntities {
    public static DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create(SwordsMod.MOD_ID, Registries.ENTITY_TYPE);

    public static RegistrySupplier<EntityType<LeafAttackEntity>> LEAF_ATTACK = registerEntity("leaf_attack",
        EntityType.Builder.of(
            LeafAttackEntity::new, MobCategory.MISC
        ));

    public static <T extends Entity> RegistrySupplier<EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        ResourceLocation entTypeID = ResourceLocation.fromNamespaceAndPath(SwordsMod.MOD_ID, name);
        return ENTITY_TYPES.register(entTypeID, () -> builder.build(entTypeID.toString()));
    }

    public static void register(){
        ENTITY_TYPES.register();
    }
}
