package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import net.minecraft.core.component.DataComponents;
import net.minecraft.item.*;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

public class PotionSwordItem extends SwordtemberItem {

    public PotionSwordItem(Item.Properties itemSettings) {
        super(Tiers.IRON, itemSettings.attributes(
            SwordItem.createAttributes(Tiers.IRON, 3, -2.4f))
        );
    }

    // mutates given item stacks if needed.
    // returns a side-product stack, ex: glass bottle if filling with a potion, potion if emptying into a glass bottle.
    public ItemStack tryFillSword(ItemStack swordStack, ItemStack fillStack, boolean shouldDecrement){
        if(swordStack.getItem() != this) return fillStack;
        // it'd be cool to be able to empty the sword back into potions, but doesn't seem very do-able since i don't see an easy way to split the duration
//        if(swordStack.contains(DataComponentTypes.POTION_CONTENTS)){
//            if(fillStack.getItem() == Items.GLASS_BOTTLE){
//                // handle emptying
//                PotionContentsComponent swordPotionContents = swordStack.get(DataComponentTypes.POTION_CONTENTS);
//                fillStack.decrement(1);
//                int hitsLeft = swordStack.getOrDefault(SwordsModComponents.POTION_HITS, 0);
//
//                ItemStack newPotion = new ItemStack(Items.POTION);
//            }
//            return ItemStack.EMPTY;
//        }
        if(swordStack.has(DataComponents.POTION_CONTENTS)) return ItemStack.EMPTY;
        // handle filling
        if(fillStack.getItem() != Items.POTION) return ItemStack.EMPTY; // TODO: this *could* be tag based, but that makes the glass bottle returning part harder-ish
        if(!fillStack.has(DataComponents.POTION_CONTENTS)) return ItemStack.EMPTY;
        PotionContents potionContents = fillStack.get(DataComponents.POTION_CONTENTS);

        swordStack.set(DataComponents.POTION_CONTENTS, potionContents);
        swordStack.set(SwordsModComponents.POTION_HITS, 5);
        if(shouldDecrement){
            fillStack.shrink(1);
        }

        return Items.GLASS_BOTTLE.getDefaultInstance();
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack swordStack = user.getItemInHand(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND; // a hand.otherHand() helper would be nice..
        ItemStack otherHandStack = user.getItemInHand(otherHand);
        ItemStack resultStack = tryFillSword(swordStack, otherHandStack, !user.getAbilities().instabuild);
        if(resultStack.isEmpty()){
            return InteractionResultHolder.pass(swordStack);
        }
        RandomSource random = world.getRandom();
        world.playSound(null, user.blockPosition(), SoundEvents.BREWING_STAND_BREW, SoundSource.PLAYERS,
            1f, (random.nextFloat() - random.nextFloat()) * 0.2f + 2f);
        if(otherHandStack.isEmpty()){
            user.setItemInHand(otherHand, resultStack);
        } else {
            if(!user.getAbilities().instabuild){
                user.addItem(resultStack);
            }
        }
        return InteractionResultHolder.success(swordStack);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if(stack.has(DataComponents.POTION_CONTENTS)){
            PotionContents potionContents = stack.get(DataComponents.POTION_CONTENTS);
            int hitsLeft = stack.getOrDefault(SwordsModComponents.POTION_HITS, 0);
            if(hitsLeft > 0){
                potionContents.forEachEffect(effect -> {
                    MobEffectInstance lesserInstance = new MobEffectInstance(effect.getEffect(),
                        Math.round(effect.getDuration() / 5f), effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), effect.showIcon());
                    target.addEffect(lesserInstance, attacker);
                });
            }
            if(hitsLeft - 1 > 0){
                if(!(attacker instanceof Player player && player.getAbilities().instabuild))
                    stack.set(SwordsModComponents.POTION_HITS, hitsLeft-1);
            } else {
                stack.remove(SwordsModComponents.POTION_HITS);
                stack.remove(DataComponents.POTION_CONTENTS);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0x69adf0);
    }

    @Override
    public void appendHoverText(ItemStack stack, TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if(stack.has(DataComponents.POTION_CONTENTS)){
            PotionContents potionContents = stack.get(DataComponents.POTION_CONTENTS);
            List<Component> potionTooltip = new ArrayList<>();
            potionContents.addPotionTooltip((potionTooltipLine) -> {
                potionTooltip.add(potionTooltipLine);
            }, 1, context.tickRate());
            tooltip.addAll(2, potionTooltip);
        }
    }
}
